let timeClear = document.getElementById("clearTime")
let timeClear2 = document.getElementById("clearTime2")
let config = "https://www.xiongmaodaili.com/"
let backendExtUrl = {
    Login: `${config}xiongmao-web/user/login`,
    UserInfo: `${config}xiongmao-web/user/userInfo`,
    Logout: `${config}xiongmao-web/user/logout`,
    GetUserIp: `${config}xiongmao-web/whilteList/getUserIp`,
    ListOrder: `${config}xiongmao-web/order/listUseableOrder`,
    ListUserIp: `${config}xiongmao-web/clientWhilteList/listUserIp`,
    SelfControl: `${config}xiongmao-web/selfControl/applyMachine`,
    IPLocation: `${config}xiongmao-web/checkIp/ipList2`,
    ListArea: `${config}xiongmao-web/apiPlus/listArea`,
    Findall: `${config}xiongmao-web/vip20/area/findall`,
}
let nodeLoginButton = document.getElementById("input-login"),
    nodeTemplateMessageHard = document.getElementById("template-popup-message-hard").firstElementChild,
    nodeTemplateMessageSoft = document.createElement("section"),
    nodePageLogin = document.getElementById("page-login"),
    nodePageAutoLogin = document.getElementById("page-auto-login"),
    nodePageUser = document.getElementById("page-user"),
    nodePageInfo = document.getElementById("page-info"),
    nodePageOrder = document.getElementById("page-order"),
    nodeLogoutButton = document.getElementById("input-logout"),
    nodeAutoLoginButton = document.getElementById("auto-login"),
    nodePhone = document.getElementById("my-phone"),
    nodeName = document.getElementById("my-name"),
    nodeIP = document.getElementById("ip-show"),
    nodeIPLocation = document.getElementById("ip-location"),
    nodeIPProvider = document.getElementById("ip-provider"),
    nodeIPtxt = document.getElementById("toggle-ip-show"),
    noNetwork = document.getElementById("no-network"),
    loadingNetwork = document.getElementById("loading-network"),
    connectNetwork = document.getElementById("connect-network"),
    noOrder = document.getElementById("no-order"),
    haveOrder = document.getElementById("have-order"),
    orderName = document.getElementById("order-name"),
    orderNo = document.getElementById("order-no"),
    orderCheck = document.getElementById("check-set"),
    cityCheck = document.getElementById("check-city"),
    ipSwitch = document.getElementById("ip-switch"),
    ipBreak = document.getElementById("ip-break"),
    showTime = document.getElementById("show_time"),
    setAlarms = document.getElementById("set-alarms"),
    setCity = document.getElementById("set-city"),
    setTimer = document.getElementById("set-timer"),
    setCityChange = document.getElementById("set-cityChange"),
    setCancel = document.getElementById("button-cancel"),
    setCancel2 = document.getElementById("button-cancel2"),
    setSure = document.getElementById("button-sure"),
    setSure2 = document.getElementById("button-sure2"),
    setClose = document.getElementById("close"),
    setClose2 = document.getElementById("close2"),
    getHours = document.getElementById("xh_hours"),
    getMinute = document.getElementById("xh_minute"),
    getSecond = document.getElementById("xh_second"),
    checkTrue = document.getElementById("check-true"),
    checkTrue2 = document.getElementById("check-true2"),
    checkFalse = document.getElementById("check-false"),
    checkFalse2 = document.getElementById("check-false2"),
    timeShow = document.getElementById("time-show"),
    cityShow = document.getElementById("city-show"),
    otherLogin = document.getElementById("other-login"),
    pageFromId = {
        "page-login": nodePageLogin,
        "page-user": nodePageUser,
        "page-info": nodePageInfo,
        "page-order": nodePageOrder,
        "page-auto-login": nodePageAutoLogin,
    },
    networkFromId = {
        "no-network": noNetwork,
        "loading-network": loadingNetwork,
        "connect-network": connectNetwork,
        "no-order": noOrder,
        "have-order": haveOrder,
    }
allPages = Object.values(pageFromId)
allNetworks = Object.values(networkFromId)
async function fetchPost(a, b) {
    const response = await fetch(a, {
        method: "post",
        mode: 'cors',
        credentials: 'include',
        body: new URLSearchParams(b).toString(),
        headers: {
            "Content-Type": "application/x-www-form-urlencoded"
        },
    }).then(c => {
        console.log("post", c)
        return fetchHandler(c, fetchPost, [a, b])
    }).catch(c => fetchErrorHandler(c))
    return response
}
async function fetchGet(a, b) {
    const response = await fetch(a, {
        method: "get",
        mode: 'cors',
        credentials: 'include',
    }).then(c => {
        return fetchHandler(c, fetchGet, [a, b])
    }).catch(c => fetchErrorHandler(c))
    return response
}
//浏览器代理
async function thisGetAPi(respams, ind, timeValue, xhr) {
    let thisIP = ''
    let thisPORT = ''
    if (respams.type == 5) {
        //独享代理
        thisIP = JSON.parse(xhr.response).obj.ip
        thisPORT = JSON.parse(xhr.response).obj.port
    } else {
        thisIP = JSON.parse(xhr.response).obj[0].ip
        thisPORT = JSON.parse(xhr.response).obj[0].port
    }
    nodeIPtxt.style.display = "none";
    let parmars = {
        bypassList: respams.whiteIp,
        ip: thisIP,
        port: thisPORT,
        userName: respams.userName,
        password: respams.password,
        type: respams.verifyType,
        orderType: respams.type
    }
    chromeSet(parmars, ind, timeValue)
}
async function httpRequest(respams, ind, timeValue) {
    // 创建 XMLHttpRequest 对象
    const xhr = new XMLHttpRequest();
    // 指定请求的方法和 URL
    xhr.open('GET', respams.url, true); // 第三个参数 true 表示异步请求
    // 发送请求
    xhr.send();
    // 监听 load 事件
    xhr.addEventListener('load', function () {
        if (JSON.parse(xhr.response).code == 0) {
            console.log('监听 load 事件', JSON.parse(xhr.response))
            let arrOBJ = JSON.parse(xhr.response).obj
            chrome.storage.local.set({
                'xmApi': arrOBJ
            })
            setTimeout(() => {
                thisGetAPi(respams, ind, timeValue, xhr)
            }, 200)
        } else {
            setTimeout(() => {
                showMessage(JSON.parse(xhr.response).msg)
                initNetwork('no-network')
                if (ind == 2) {
                    chrome.storage.local.remove("timerValue")
                    chrome.storage.local.remove("timerTime")
                    chrome.storage.local.remove("timer")
                    checkTrue.style.display = 'none'
                    checkFalse.style.display = 'block'
                    timeShow.innerHTML = ''
                }
                chrome.storage.local.get(["ip_addr"], (result) => {
                    if (result.ip_addr) {
                        nodeIP.innerHTML = result.ip_addr
                        nodeIPtxt.style.display = "black";
                        nodeIPtxt.innerHTML = '本机'
                    }
                })
            }, 500)

        }

    });
    xhr.onerror = function () { // 仅在根本无法发出请求时触发
        console.log(`网络错误`)
        showMessage(`网络错误`);
    };
}

function chromeSet(proxyPort, ind, timeValue) {
    let proxyConfig = {
        mode: "fixed_servers",
        rules: {
            singleProxy: {
                scheme: "http",
                host: proxyPort.ip,
                port: parseInt(proxyPort.port)
            },
        }

    };
    let proxyAuth = {}
    if (proxyPort.type == 1) {
        proxyConfig.rules.bypassList = proxyPort.whiteIp
    }
    if (proxyPort.type == 2) {
        proxyAuth = {
            username: proxyPort.username,
            password: proxyPort.password,
        }
    }
    chrome.storage.sync.set({
        proxyConfig: proxyConfig,
        proxyAuth: proxyAuth
    }, function () {
        chrome.proxy.settings.set({
            value: proxyConfig,
            scope: "regular"
        }, function () {
            initNetwork('connect-network')
            let parmars = {
                oldTime: new Date().getTime(),
                newTime: new Date().getTime(),
                netWork: true,
            }
            chrome.storage.local.set({
                'netWork': parmars
            })
            chrome.storage.local.set({
                'alarms': true
            })
            showTime.innerHTML = '00:00:00'
            showMessage('连接成功')
            getIps(backendExtUrl, proxyPort)
            if (ind == 2) {
                setMYtimer(timeValue)
            }
            setTimeout(() => {
                Timer()
            }, 1000)
        });
    });
}

function calculationTime(culationTime) {
    var time = Math.abs(culationTime.newTime - culationTime.oldTime) / 1000; //毫秒差值
    var h = parseInt(time / 60 / 60 % 24)
    h = h < 10 ? '0' + h : h
    let m = parseInt(time / 60 % 60)
    m = m < 10 ? '0' + m : m
    let s = parseInt(time % 60)
    s = s < 10 ? '0' + s : s
    let returnTime = h + ':' + m + ':' + s
    return returnTime
}

function Timer() {
    chrome.storage.local.get(["ip_addr"], (results) => {
        if (results.ip_addr) {
            nodeIP.innerHTML = results.ip_addr
        }
    });
    // chrome.storage.local.get(["xmApi"], (result2) => {
    //     if (result2.xmApi) {
    //         if(Object.getPrototypeOf(result2.xmApi) === Object.prototype ){
    //             nodeIP.innerHTML = result2.xmApi.ip
    //         }else{
    //             nodeIP.innerHTML = result2.xmApi[0].ip
    //         }
    //     }
    // });
    chrome.storage.local.get(["netWork"], (result) => {
        if (result.netWork) {
            chrome.storage.local.get(["alarms"], (results) => {
                if (results.alarms) {
                    let obj = result.netWork
                    let newTime = new Date().getTime()
                    let oldTime = result.netWork.oldTime
                    showTime.innerHTML = calculationTime(result.netWork)
                    timeClear = setTimeout(() => {
                        newTime++
                        obj.newTime = newTime
                        obj.oldTime = result.netWork.oldTime
                        chrome.storage.local.set({
                            'netWork': obj
                        })
                        Timer()
                    }, 1000)


                }
            })

        }
    })
}
async function myUser(backendExtUrl) {
    fetchPost(backendExtUrl.UserInfo, {}).then(k => {
        if (k.code != 0) {
            showMessage('登录国企')
        }
    })
}
async function fetchHandler(a, b, c) {
    a = await a.json();
    return a
}

function fetchErrorHandler(a) {
    chrome.storage.local.get(["netWork"], (result) => {
        if (result.netWork) {
            return showMessage('连接ip已经失效，请重新切换')
        } else {
            return showMessage('网络连接失败')
        }
    })
}

function closeSoftMessages() {
    let a = document.getElementsByClassName("soft");
    for (let b = 0; b < a.length; b++)
        a[b].remove()
}

function showMessage(a) {
    const b = a;
    console.log('showMessage', a, b)
    if (b) {
        var c = "soft",
            d = null,
            k = 400;
        closeSoftMessages()
        d = nodeTemplateMessageSoft.cloneNode(!0)
        d.closeSelf = function (m) {
            setTimeout(() => this.style.opacity = "0", m),
                setTimeout(() => this.style.display = "none", m + k)
        };
        document.body.append(d);
        d.classList.add(c);
        if ("soft" === c)
            d.classList.add("popup-message"),
            d.innerHTML = b,
            d.style.display = "block",
            setTimeout(() => d.style.opacity = "1", 100),
            d.closeSelf(2000);
    }
}

async function putOrder(data, haveCheck) {
    let str = ''
    let haveIndex = -1
    data.forEach((item, index) => {
        str = str + `<div class="order-radio">
        <input type="radio" name="choice" value='${item.orderNo}' />
        <label for="${item.orderNo}">
            <div class="label-name">${item.orderName}</div>
            <div class="label-order">${item.orderNo}</div>
        </label>
        </div>`
        if (haveCheck && haveCheck == item.orderNo) {
            haveIndex = index
        }
    })
    haveOrder.innerHTML = str
    const orderList = haveOrder.getElementsByClassName('order-radio')
    const choice = document.getElementsByName('choice');
    Array.from(orderList).forEach((item, index) => {
        if (haveIndex >= 0) {
            choice[haveIndex].checked = true
        }
        item.addEventListener("click", async () => {
            choice[index].checked = true
            let obj = {
                orderName: data[index].orderName,
                orderNo: data[index].orderNo,
                type: data[index].type,
                poolType: data[index].poolType,
            }
            chrome.storage.local.set({
                'xmOrder': obj
            })
            showMessage('订单切换成功')
            chrome.storage.local.remove("cityValue")
            let dxApi = await chrome.storage.local.get("dxApi")
            if(dxApi.dxApi && dxApi.dxApi.orderNo == obj.orderNo){
            }else{
                chrome.storage.local.remove("dxApi")
            }
            setTimeout(() => {
                initPage('page-user')
            }, 200)

        })
    })
}

function getIps(backendExtUrl, proxyPort) {
    fetchPost(backendExtUrl.GetUserIp, {}).then(async k => {
        if (k.code == 0) {
            chrome.storage.local.set({
                'ip_addr': k.obj
            })
            nodeIPLocation.innerHTML = ''
            nodeIP.innerHTML = k.obj
            //检查有无代理
            let alarms = await chrome.storage.local.get(["alarms"])
            let ipName = await chrome.storage.local.get(["ip_addrName"])
            if (alarms.alarms) {} else {
                nodeIPtxt.style.display = "black";
                nodeIPtxt.innerHTML = '本机'
            }
            let arr = []
            if (proxyPort) {
                arr.push(proxyPort.ip + ":" + proxyPort.port)
                ipRequest(backendExtUrl.IPLocation + `?ip_ports[]=${arr}`, function (content) {
                    var ipNames = (content.obj)[0].position
                    if (ipNames) {
                        nodeIPLocation.innerHTML = ipNames
                    } else {
                        ipNames = '暂未识别IP地址'
                        nodeIPLocation.innerHTML = '暂未识别IP地址'
                    }
                    let obj = {
                        ipName: ipNames
                    }
                    chrome.storage.local.set({
                        'ip_addrName': obj
                    })
                });
            } else {
                if (ipName.ip_addrName) {
                    nodeIPLocation.innerHTML = ipName.ip_addrName.ipName
                } else {
                    ipRequest('https://qifu-api.baidubce.com/ip/geo/v1/district?ip='+k.obj, function (content) {
                        if (content.code == "Success") {
                            let data = content.data
                            let ipName = data.city + data.district + " " + data.isp
                            nodeIPLocation.innerHTML = ipName
                            let obj = {
                                ipName: ipName
                            }
                            chrome.storage.local.set({
                                'ip_addrName': obj
                            })
                        }
                    });
                    // ipRequest('https://www.ip.cn/api/index?ip&type=0', function (content) {
                    //     if (content.code == 0) {
                    //         let data = content.address.split(' ')
                    //         let ipName = data[2] + data[3] + " " + data[4]
                    //         nodeIPLocation.innerHTML = ipName
                    //         let obj = {
                    //             ipName: ipName
                    //         }
                    //         chrome.storage.local.set({
                    //             'ip_addrName': obj
                    //         })
                    //     }
                    // });
                }

            }
        }
    })
}
async function showPage$$module$popup_original(a, b) {
    await browser$$module$popup_original.setStorageItem("currentPageId", a, cache$$module$popup_original);
    await initPage(a, b)
}
async function initNetwork(a, b) {
    console.log(123, a)
    switch (a) {
        case "no-network":
            break;
    }
    allNetworks.forEach(c => c.style.display = "none");
    networkFromId[a].style.display = "flex";
}
async function initPage(a, b) {
    switch (a) {
        case "page-user":
            initNetwork('no-network')
            getIps(backendExtUrl)
            //有无城市
            citytoShow()
            chrome.storage.local.get(["netWork"], (result) => {
                chrome.storage.local.get(["alarms"], (results) => {
                    if (results.alarms) {
                        initNetwork('connect-network')
                        nodeIPtxt.style.display = "none";
                        Timer()
                    } else {
                        initNetwork('no-network')
                        chrome.storage.local.get(["ip_addr"], (result) => {
                            if (result.ip_addr) {
                                nodeIP.innerHTML = result.ip_addr
                                nodeIPtxt.style.display = "black";
                                nodeIPtxt.innerHTML = '本机'
                            }
                        })
                    }
                })
            })
            chrome.storage.local.get(["xmOrder"], (result) => {
                if (result.xmOrder && (result.xmOrder.orderName || result.xmOrder.orderNo)) {
                    orderName.innerHTML = result.xmOrder.orderName
                    orderNo.innerHTML = result.xmOrder.orderNo
                } else {
                    setMYcity('', false)
                    orderName.innerHTML = '选择代理订单'
                    orderNo.innerHTML = ''
                }
            })
            chrome.storage.local.set({
                'xmLogin': true
            })
            break;
        case "page-info":
            chrome.storage.local.get(["userInfo"], (result) => {
                if (result.userInfo) {
                    nodePhone.innerHTML = result.userInfo.mobile
                    nodeName.innerHTML = result.userInfo.userName
                }
            })
            break;
        case "page-order":


            break;
    }
    allPages.forEach(c => c.style.display = "none");
    pageFromId[a].style.display = "flex";
}

function ipRequest(url, callback) {
    var xhr = new XMLHttpRequest();
    xhr.open("GET", url, true);
    xhr.send();
    xhr.addEventListener('load', function () {
        chrome.storage.local.remove('ip_addrName')
        if (JSON.parse(xhr.response).code == 0 || JSON.parse(xhr.response).code == 'Success') {
            console.log(22222222222, JSON.parse(xhr.response))
            callback(JSON.parse(xhr.response));
        } else {
            chrome.storage.local.remove('ip_addrName')
        }
    })
}
//获取提取api 地址
async function getApiUrl(tar, secret, orderNo, type) {
    let url = ''
    let str = ''
    //高效代理(按量)
    if (tar == 1) {
        url = 'https://www.xiongmaodaili.com/xiongmao-web/api/glip'
        str = `?secret=${secret}&orderNo=${orderNo}&count=1&isTxt=0&proxyType=1&returnAccount=${type}`
    }
    //独享代理
    if (tar == 5) {
        url = 'https://www.xiongmaodaili.com/xiongmao-web/selfControl/getIP'
        str = `?secret=${secret}&orderNo=${orderNo}&code=0&type=0&returnAccount=${type}`
    }
    //包量套餐(升级版)
    if (tar == 15) {
        let cityId = ''
        let data = await chrome.storage.local.get("cityValue")
        if (data && data.cityValue) {
            cityId = data.cityValue.cityValue2 ? data.cityValue.cityValue2 : ''
        }
        url = 'https://www.xiongmaodaili.com/xiongmao-web/apiPlus/vgl'
        str = `?secret=${secret}&orderNo=${orderNo}&count=1&isTxt=0&proxyType=1&validTime=0&removal=0&cityIds=${cityId}&returnAccount=${type}`
    }
    //包量套餐(包时版)
    if (tar == 20) {
        url = 'https://www.xiongmaodaili.com/xiongmao-web/api/bgl'
        str = `?secret=${secret}&orderNo=${orderNo}&count=1&isTxt=0&proxyType=1&returnAccount=${type}`
    }
    //隧道短效
    if (tar == 21) {
        url = 'https://www.xiongmaodaili.com/xiongmao-web/sdApi/sdl'
        str = `?secret=${secret}&orderNo=${orderNo}&count=1&isTxt=0&proxyType=1&noTime=0&removal=0&provinceIds=&cityIds=&returnAccount=${type}`
    }
    //隧道长效
    if (tar == 23) {
        url = 'https://www.xiongmaodaili.com/xiongmao-web/sdApi/sdc'
        str = `?secret=${secret}&orderNo=${orderNo}&count=1&isTxt=0&proxyType=1&noTime=1&removal=0&provinceIds=&cityIds=&returnAccount=${type}`
    }
    //隧道企业池
    if (tar == 27) {
        let cityId = ''
        let data = await chrome.storage.local.get("cityValue")
        if (data && data.cityValue) {
            cityId = data.cityValue.cityValue2 ? data.cityValue.cityValue2 : ''
        }
        url = 'https://www.xiongmaodaili.com/xiongmao-web/vsdApi/vsd'
        str = `?secret=${secret}&orderNo=${orderNo}&count=1&isTxt=0&proxyType=1&only=false&cityId=${cityId}&returnAccount=${type}`
    }
    return url + str
}
//获取白名单
async function getUserIP(backendExtUrl, parmars) {
    const data = await fetchGet(backendExtUrl.ListUserIp + '?secret=' + parmars.secret).then(k => {
        return k
    })
    return data
}
//订单操作
function dataCut(data) {
    const dataArr = []
    data.forEach((item) => {
        if (item.type != 1 && item.type != 15 && item.type != 5 && item.type != 20 && item.type != 21 && item.type != 23 && item.type != 27) {
            return
        }
        let obj = {
            orderNo: item.orderNo,
            orderName: '',
            type: item.type,
            poolType: item.poolType,
        }
        if (item.type == 1) {
            obj.orderName = '高效代理(按量)'
        }
        if (item.type == 5) {
            obj.orderName = '独享代理'
        }
        if (item.type == 15) {
            obj.orderName = '包量套餐(升级版)'
        }
        if (item.type == 20) {
            obj.orderName = '包量套餐(包时版)'
        }
        if (item.type == 21) {
            obj.orderName = '隧道短效套餐'
        }
        if (item.type == 23) {
            obj.orderName = '隧道长效套餐'
        }
        if (item.type == 27 && item.poolType == 1) {
            obj.orderName = '1分钟套餐(隧道企业池)'
        }
        if (item.type == 27 && item.poolType == 2) {
            obj.orderName = '3分钟套餐(隧道企业池)'
        }
        if (item.type == 27 && item.poolType == 3) {
            obj.orderName = '5分钟套餐(隧道企业池)'
        }
        if (item.type == 27 && item.poolType == 4) {
            obj.orderName = '10分钟套餐(隧道企业池)'
        }
        if (item.type == 27 && item.poolType == 5) {
            obj.orderName = '30分钟套餐(隧道企业池)'
        }
        dataArr.push(obj)
    })
    if (dataArr.length == 0) {
        initNetwork('no-order')
    } else {
        chrome.storage.local.get(["xmOrder"], (result) => {
            if (result.xmOrder) {
                putOrder(dataArr, result.xmOrder.orderNo)
            } else {
                putOrder(dataArr)
            }
        })
    }
}
//代理关闭
function setClear() {
    chrome.proxy.settings.clear({
        scope: "regular"
    }, function () {
        clearTimeout(timeClear)
        chrome.storage.local.remove("netWork")
        chrome.storage.local.remove("alarms")
        chrome.storage.local.remove("xmApi")
    });
}
//时间格式化
function format(dataString) {
    //dataString是整数，否则要parseInt转换
    var time = new Date(dataString);
    var year = time.getFullYear();
    var month = time.getMonth() + 1;
    month = month < 10 ? '0' + month : month
    var day = time.getDate();
    day = day < 10 ? '0' + day : day
    let hour = time.getHours();
    hour = hour < 10 ? '0' + hour : hour
    var minute = time.getMinutes();
    minute = minute < 10 ? '0' + minute : minute
    var second = time.getSeconds();
    second = second < 10 ? '0' + second : second
    return year + '-' + month < +'-' + day + ' ' + hour + ':' + minute + ':' + second
}
//时间倒计时
function Timer2(ind) {
    clearTimeout(timeClear2)
    chrome.storage.local.get(["timerTime"], (result) => {
        if (result.timerTime) {
            let timeValue = ''
            let endTime = ''
            chrome.storage.local.get(["timerValue"], (res) => {
                if (res.timerValue) {
                    timeValue = res.timerValue
                }
            })
            chrome.storage.local.get(["endTime"], (res) => {
                if (res.endTime) {
                    endTime = res.endTime
                }
            })
            chrome.storage.local.get(["timer"], (results) => {
                if (results.timer) {
                    let newTime = endTime
                    let oldTime = new Date().getTime()
                    let obj = {
                        newTime: newTime,
                        oldTime: new Date().getTime(),
                    }
                    //倒计时结束 代理ip
                    if (oldTime > endTime) {
                        clearTimeout(timeClear2)
                        chrome.storage.local.remove("timer")
                        setClear()
                        switchIP(backendExtUrl, 2, timeValue)
                    } else {
                        timeShow.innerHTML = calculationTime(obj)
                        timeClear2 = setTimeout(() => {
                            let objValue = {
                                timeValue: timeValue,
                                startTime: new Date().getTime(),
                                startTimeStr: format(new Date().getTime()),
                                endTime: endTime,
                                endTimeStr: format(endTime)
                            }
                            chrome.storage.local.set({
                                'timerTime': objValue
                            })
                            Timer2()
                        }, 1000)
                    }

                }
            })

        }
    })
}
//城市
function setMYcity(timeValue, status) {
    chrome.storage.local.remove("cityValue")
    if (status) {
        setCity.style.display = 'none'
        checkTrue2.style.display = 'block'
        checkFalse2.style.display = 'none'
    } else {
        setCity.style.display = 'none'
        checkTrue2.style.display = 'none'
        checkFalse2.style.display = 'block'
        chrome.storage.local.remove("cityValue")
    }
    chrome.storage.local.set({
        'cityValue': timeValue
    })
}
//定时
function setMYtimer(timeValue, status) {
    chrome.storage.local.remove("timer")
    chrome.storage.local.remove("timerTime")
    chrome.storage.local.remove("timerValue")
    chrome.storage.local.remove("endTime")
    if (status) {
        setAlarms.style.display = 'none'
        checkTrue.style.display = 'block'
        checkFalse.style.display = 'none'
    }
    let objTime = {
        newTime: new Date().getTime() + timeValue * 1000,
        oldTime: new Date().getTime(),
    }
    timeShow.innerHTML = calculationTime(objTime)
    chrome.storage.local.set({
        'timer': true
    })
    let obj = {
        timeValue: timeValue,
        startTime: new Date().getTime(),
        startTimeStr: format(new Date().getTime()),
        endTime: new Date().getTime() + (timeValue + 1) * 1000,
        endTimeStr: format(new Date().getTime() + (timeValue + 1) * 1000)
    }
    chrome.storage.local.set({
        'timerTime': obj
    })
    chrome.storage.local.set({
        'timerValue': timeValue
    })
    chrome.storage.local.set({
        'endTime': new Date().getTime() + (timeValue + 1) * 1000
    })
    setTimeout(() => {
        Timer2(1)
    }, 1000)
}
//白名单
async function switchIP(backendExtUrl, ind, timeValue) {
    initNetwork('loading-network')
    setClear()
    chrome.storage.local.remove("xmApi")
    chrome.storage.local.get(["userInfo"], async (result) => {
        if (result.userInfo) {
            let userInfo = result.userInfo
            let verifyType = userInfo.verifyType
            let verifyAccount = userInfo.verifyAccount
            let verifyPassword = userInfo.verifyPassword
            let secret = userInfo.secret
            let whiteIp = []
            //白名单验证
            if (verifyType == 1) {
                let parmars = {
                    secret: secret
                }
                let white = await getUserIP(backendExtUrl, parmars)
                if (white.obj && white.obj.length) {
                    white.obj.forEach((item) => {
                        whiteIp.push(item.ip)
                    })
                }
            }
            //账号密码
            if (verifyType == 2) {

            }
            chrome.storage.local.get(["xmOrder"], async (result) => {
                if (result.xmOrder && result.xmOrder.orderName && result.xmOrder.orderNo) {
                    //提取api
                    const apiUrl = await getApiUrl(result.xmOrder.type, secret, result.xmOrder.orderNo, verifyType)
                    const parmars = {
                        url: apiUrl,
                        username: verifyAccount,
                        password: verifyPassword,
                        whiteIp: whiteIp,
                        verifyType: verifyType,
                        type: result.xmOrder.type
                    }
                    console.log('提取api', apiUrl)
                    let dxApi = await chrome.storage.local.get("dxApi")
                    //独享订单
                    if (result.xmOrder.type == 5) {
                        //直接提取
                        if (dxApi.dxApi && dxApi.dxApi.ip && dxApi.dxApi.orderNo == result.xmOrder.orderNo) {
                            httpRequest(parmars, ind, timeValue)
                            return
                        } else {
                            console.log('独享订单重新分配')
                            //重新分配提取
                            showMessage('节点分配中')
                            const dataType = await fetchGet(backendExtUrl.SelfControl + '?area=&secret=' + secret + '&orderNo=' + result.xmOrder.orderNo).then(k => {
                                return k
                            })
                            if (dataType.code == 0) {
                                setTimeout(() => {
                                    showMessage('节点分配成功')
                                }, 400)
                                chrome.storage.local.set({
                                    'dxApi': {
                                        ip: true,
                                        orderNo: result.xmOrder.orderNo
                                    }
                                })
                                setTimeout(() => {
                                    httpRequest(parmars, ind, timeValue)
                                }, 600)
                            } else {
                                showMessage(dataType.msg)
                                initNetwork('no-network')
                            }
                        }

                    } else {
                        httpRequest(parmars, ind, timeValue)
                    }
                } else {
                    setTimeout(() => {
                        initNetwork('no-network')
                        showMessage('请选择订单!')
                        chrome.storage.local.remove("cityValue")
                        chrome.storage.local.remove("timerTime")
                        chrome.storage.local.remove("timer")
                        checkTrue.style.display = 'none'
                        checkTrue2.style.display = 'none'
                        checkFalse.style.display = 'block'
                        checkFalse2.style.display = 'block'
                        timeShow.innerHTML = ''
                    }, 1000)
                }
            })
        } else {

        }
    })
}
// 检查有无城市
async function citytoShow() {
    //有无订单
    let xmOrder = await chrome.storage.local.get(["xmOrder"])
    //有无城市
    let resultCity = await chrome.storage.local.get(["cityValue"])
    if (xmOrder.xmOrder && (xmOrder.xmOrder.type == 15 || xmOrder.xmOrder.type == 27)) {
        if (resultCity.cityValue && resultCity.cityValue.cityValue1) {
            checkTrue2.style.display = 'block'
            checkFalse2.style.display = 'none'
            cityShow.style.display = 'block'
        } else {
            checkTrue2.style.display = 'none'
            checkFalse2.style.display = 'block'
            cityShow.style.display = 'block'
        }
    } else {
        checkTrue2.style.display = 'none'
        checkFalse2.style.display = 'none'
        cityShow.style.display = 'none'
    }

}
document.addEventListener('DOMContentLoaded', function () {
    const nodeLoginButton = document.getElementById("input-login")
    const nodeTabWeb = document.getElementById("tab-web")
    const nodeTapInfo = document.getElementById("tap-info")
    const nodeTapBuy = document.getElementById("tap-buy")
    const nodeTapBuy2 = document.getElementById("tap-buy2")
    const nodeTapUser = document.getElementById("tab-user")
    const nodeTapUser2 = document.getElementById("tab-user2")
    const nodeTapOrder = document.getElementById("tab-order")
    const nodeTapInfoRefresh = document.getElementById("tab-info-refresh")
    const nodeTapInfoRefresh2 = document.getElementById("tab-info-refresh2")
    setTimeout(async () => {
        let returnTimer = false
        // 检查有无计时器
        let result = await chrome.storage.local.get(["timer"])
        if (result.timer) {
            returnTimer = true
            timeShow.innerHTML = ''
            setAlarms.style.display = 'none'
            checkTrue.style.display = 'block'
            checkFalse.style.display = 'none'
        }
        citytoShow()
        //检查有无代理
        let resultAlarms = await chrome.storage.local.get(["alarms"])
        let resultInfo = await chrome.storage.local.get(["userInfo"])
        let resultlogin = await chrome.storage.local.get(["xmLogin"])
        if (resultAlarms.alarms) {
            initPage("page-user")
            if (returnTimer) {
                Timer2(1)
            }
        } else {
            fetchPost(backendExtUrl.UserInfo, {}).then(k => {
                //web登录过
                if (k.code == 0) {
                    //登陆过
                    if (resultInfo.userInfo) {
                        //同一个号
                        if (resultInfo.userInfo.id == k.obj.id) {
                            if (resultlogin.xmLogin) {
                                initPage("page-user")
                                if (returnTimer) {
                                    Timer2(1)
                                }
                            } else {
                                initPage("page-auto-login")
                            }
                        } else {
                            chrome.storage.local.clear()
                            initPage("page-auto-login")
                            chrome.storage.local.set({
                                'userInfo': k.obj
                            })
                        }
                    } else {
                        chrome.storage.local.remove("xmOrder")
                        initPage("page-auto-login")
                        chrome.storage.local.set({
                            'userInfo': k.obj
                        })
                    }
                } else {
                    chrome.storage.local.clear()
                    initPage("page-login")
                }
            })
        }
    }, 20);
    //一键切换
    ipSwitch.addEventListener('click', function () {
        chrome.proxy.settings.clear({
            scope: "regular"
        }, function () {
            console.log('一键切换')
            switchIP(backendExtUrl, 1)
        });
    })
    //自动登录
    nodeAutoLoginButton.addEventListener('click', function () {
        fetchPost(backendExtUrl.UserInfo, {}).then(k => {
            if (k.code == 0) {
                chrome.storage.local.set({
                    'userInfo': k.obj
                })
                showMessage('登录成功!')
                initPage("page-user")
            } else {
                showMessage('自动登录失败!')
            }
        })
    })
    //刷新 个人中心
    nodeTapInfoRefresh.addEventListener('click', function () {
        fetchPost(backendExtUrl.UserInfo, {}).then(k => {
            if (k.code == 0) {
                showMessage('刷新成功!')
                chrome.storage.local.set({
                    'userInfo': k.obj
                })
                initPage("page-info")
            } else {
                initPage("page-login")
            }
        })
    })
    //刷新订单
    nodeTapInfoRefresh2.addEventListener('click', function () {
        fetchPost(backendExtUrl.ListOrder, {}).then(k => {
            if (k.code == 0) {
                showMessage('刷新成功!')
                const data = k.obj
                if (data && data.length) {
                    dataCut(data)
                } else {
                    initNetwork('no-order')
                }
            }
        })
    })
    //登录
    nodeLoginButton.addEventListener('click', function () {
        const username = document.getElementById('input-mobile').value;
        const password = document.getElementById('input-password').value;
        fetchPost(backendExtUrl.Login, {
            originType: 1,
            account: username,
            password: password,
        }).then(k => {
            if (k.code == 0) {
                chrome.storage.local.set({
                    'xmLogin': true
                })
                fetchPost(backendExtUrl.UserInfo, {}).then(k => {
                    if (k.code == 0) {
                        showMessage('登录成功!')
                        initPage("page-user")
                        chrome.storage.local.set({
                            'userInfo': k.obj
                        })
                    }
                })
            }
        })
    });
    // 退出登录
    nodeLogoutButton.addEventListener('click', function () {
        fetchPost(backendExtUrl.Logout, {}).then(k => {
            if (k.code == 0) {
                chrome.storage.local.clear()
                showMessage('退出成功!')
                fetchPost(backendExtUrl.UserInfo, {}).then(k => {
                    if (k.code == 0) {
                        chrome.storage.local.get(["xmLogin"], (result) => {
                            if (result.xmLogin) {
                                initPage("page-login")
                            } else {
                                initPage("page-auto-login")
                            }
                        })
                    } else {
                        initPage("page-login")
                    }
                })
            }
        })
    });
    //跳转订单2
    nodeTapOrder.addEventListener('click', function (event) {
        initPage("page-order")
        initNetwork('have-order')
        fetchPost(backendExtUrl.ListOrder, {}).then(k => {
            if (k.code == 0) {
                const data = k.obj
                if (data && data.length) {
                    dataCut(data)
                } else {
                    initNetwork('no-order')
                }
            }
        })
    });
    //跳转个人中心
    nodeTapInfo.addEventListener('click', function () {
        initPage("page-info")
    });
    //跳转登录
    otherLogin.addEventListener('click', function () {
        initPage("page-login")
    });
    //跳转首页
    nodeTapUser.addEventListener('click', function () {
        initPage("page-user")
    });
    nodeTapUser2.addEventListener('click', function () {

        initPage("page-user")
    });
    //跳转官网
    nodeTapBuy.addEventListener('click', function () {
        window.open('https://www.xiongmaodaili.com/buy')
    });
    nodeTapBuy2.addEventListener('click', function () {
        window.open('https://www.xiongmaodaili.com/buy')
    });
    nodeTabWeb.addEventListener('click', function () {
        window.open('https://www.xiongmaodaili.com/')
    });
    //定时切换按钮
    orderCheck.addEventListener('click', function (event) {
        let returnOrder = false
        chrome.storage.local.get(["xmOrder"], async (result) => {
            if (result.xmOrder && result.xmOrder.orderName && result.xmOrder.orderNo) {
                returnOrder = true
            } else {
                returnOrder = false
                initNetwork('no-network')
                showMessage('请选择订单!')

            }
        })
        chrome.storage.local.get(["timer"], (result) => {
            if (result.timer) {
                chrome.storage.local.remove("timerValue")
                chrome.storage.local.remove("timerTime")
                chrome.storage.local.remove("timer")
                setAlarms.style.display = 'none'
                checkTrue.style.display = 'none'
                checkFalse.style.display = 'block'
                timeShow.innerHTML = ''
            } else {
                if (returnOrder) {
                    setAlarms.style.display = 'block'
                }
            }
        })
        if (event.target == event.currentTarget) {

        }
    })
    //选择城市按钮
    cityCheck.addEventListener('click', async function (event) {
        let returnOrder = false
        chrome.storage.local.get(["xmOrder"], async (result) => {
            if (result.xmOrder && result.xmOrder.orderName && result.xmOrder.orderNo) {
                returnOrder = true
            } else {
                returnOrder = false
                initNetwork('no-network')
                showMessage('请选择订单!')

            }
        })
        const cityReturn = await chrome.storage.local.get(["cityValue"])
        const orderReturn = await chrome.storage.local.get(["xmOrder"])
        if (cityReturn.cityValue) {
            chrome.storage.local.remove("cityValue")
            setCity.style.display = 'none'
            checkTrue2.style.display = 'none'
            checkFalse2.style.display = 'block'
        } else {
            if (returnOrder) {
                setCity.style.display = 'block'
                let cityres
                if (orderReturn.xmOrder.type == 15) {
                    cityres = await fetchGet(backendExtUrl.ListArea + '?orderType=15&poolType=' + orderReturn.xmOrder.poolType).then(k => {
                        return k
                    })
                }
                if (orderReturn.xmOrder.type == 27) {
                    cityres = await fetchGet(backendExtUrl.Findall).then(k => {
                        return k
                    })
                }
                let cityData = cityres.obj
                chrome.storage.local.set({
                    'cityData': cityData
                })
                let fatherSel2 = document.getElementById('set-cityChange').getElementsByClassName("select2")[0]
                fatherSel2.setAttribute('value', '全省随机')
                // 获取初始的select
                let fatherSel = document.getElementById('set-cityChange').getElementsByClassName("select1")[0]
                fatherSel.setAttribute('value', '全国随机')
                fatherSel.innerHTML = `<option value="全国随机">全国随机</option>`
                // select添加option
                for (var i = 0; i < cityData.length; i++) {
                    selectAppendOpt(fatherSel, cityData[i].value, cityData[i].label)
                }
                /**
                 * 动态添加select，参数id可以不要，这里主要为演示数据不同使用
                 */
                let liveAppend2 = (id) => {
                    // 演示数据，可换成ajax请求数据
                    // 获取初始的select
                    let fatherSel = document.getElementById('set-cityChange').getElementsByClassName("select2")[0]
                    fatherSel.setAttribute('value', '全省随机')
                    fatherSel.innerHTML = `<option value="全省随机">全省随机</option>`
                    let data = []
                    cityData.forEach((item) => {
                        if (id == item.value) {
                            data = item.children
                        }
                    })
                    // // 创建下一个select
                    let select = document.getElementsByClassName('select2')[0]
                    // // 设置属性，可以不要
                    // select.setAttribute('class', 'select2')
                    // // 添加空选项
                    // let tempOpt = document.createElement('option')
                    // tempOpt.append(document.createTextNode('请选择'))
                    // select.append(tempOpt)

                    // 添加选项
                    for (var i = 0; i < data.length; i++) {
                        selectAppendOpt(fatherSel, data[i].value, data[i].label)
                    }

                    // // 获取所有select
                    // var allSelects = document.getElementById('set-cityChange').getElementsByClassName('select1')
                    // // 获取当前页面最后一个select
                    // let lastSelect = allSelects[allSelects.length - 1]
                    // // 添加新的select
                    // lastSelect.after(select);

                    // 新select绑定监听事件
                    select.addEventListener('change', function () {

                        let selectIndex = this.selectedIndex // 选中索引
                        id = this.options[selectIndex].value // 选中value
                        var text = this.options[selectIndex].text // 选中文本
                        // 删除当前select标签之后的DOM
                        delLastNode(this)
                        // 选空时不执行后面的添加操作
                        console.log(id)
                        // 如果选中的是“请选择”，则清空当前select的value
                        if (id !== '全省随机') {
                            this.setAttribute('value', id)
                        } else {
                            this.setAttribute('value', '全省随机')
                        }
                    })

                }
                // 为首个select添加监听事件
                document.getElementById('set-cityChange').getElementsByTagName('select')[0].addEventListener('change', function () {
                    let selectIndex = this.selectedIndex
                    var id = this.options[selectIndex].value
                    var text = this.options[selectIndex].text
                    console.log('选空时不执行后面的添加操作', id, text)
                    // 选空时不执行后面的添加操作
                    if (id != '全国随机') {
                        this.setAttribute('value', id)
                        liveAppend2(id)
                    } else {
                        let childNode = document.getElementsByClassName('select2')[0]
                        childNode.setAttribute('value', '全省随机')
                        childNode.innerHTML = `<option value="全省随机">全省随机</option>`
                        this.setAttribute('value', '全国随机')
                    }

                })

                /**
                 * 为select标签添加option选项
                 * @param {DOM} sel  select元素
                 * @param {str} optVal  选项值value
                 * @param {str} optContent  选项展示的文本
                 * @return void
                 */
                function selectAppendOpt(sel, optVal, optContent) {
                    let tempOpt = document.createElement('option')
                    tempOpt.append(document.createTextNode(optContent))
                    let value = document.createAttribute('value')
                    value.value = optVal
                    tempOpt.setAttributeNode(value)
                    sel.append(tempOpt)
                }
                /**
                 * 删除curNode之后的所有兄弟html元素
                 * @param {DOM} curNode  基准DOM，删除该DOM之后的兄弟元素
                 * @return void
                 */
                function delLastNode(curNode, father, all) {
                    let parentNode = curNode.parentNode
                    let brotherNodes = parentNode.children
                    let haveFind = false
                    if (father) {
                        let fatherNode = document.getElementById('divselectMask')
                        let childNode = document.getElementsByClassName('select1')
                        chrome.storage.local.set({
                            'city_num': childNode.length + 1
                        })
                        fatherNode.removeChild(parentNode)
                        return
                    }
                    for (let i = 0; i < brotherNodes.length; i++) {
                        // 获取的兄弟元素中包含了script标签，要排除，js写在body里面，但是页面看却在body外面，和select元素一级，搞不懂
                        if (brotherNodes[i]['localName'] !== 'script') {
                            if (haveFind) {
                                brotherNodes[i--].remove()
                            }
                            if (brotherNodes[i] === curNode) {
                                haveFind = true
                            }
                        }
                    }
                }
            }
        }
        if (event.target == event.currentTarget) {

        }

    })
    //关闭设置弹窗
    setAlarms.addEventListener('click', function (event) {
        if (event.target == event.currentTarget) {
            setAlarms.style.display = 'none'
        }
        // 
    }, false)
    //关闭设置弹窗
    setCity.addEventListener('click', function (event) {
        if (event.target == event.currentTarget) {
            setCity.style.display = 'none'
        }
        // 
    }, false)
    setClose.addEventListener('click', function () {
        setAlarms.style.display = 'none'
        chrome.storage.local.remove("timerValue")
        chrome.storage.local.remove("timerTime")
        chrome.storage.local.remove("timer")
    })
    setClose2.addEventListener('click', function () {
        setCity.style.display = 'none'
        chrome.storage.local.remove("cityValue")
    })
    setSure.addEventListener('click', function () {
        let timeValue = ''
        if (getHours.value !== 0) {
            timeValue = Number(getHours.value) * 60 * 60
        }
        if (getMinute.value !== 0) {
            timeValue = timeValue + Number(getMinute.value) * 60
        }
        if (getSecond.value !== 0) {
            timeValue = timeValue + Number(getSecond.value)
        }
        if (timeValue != 0) {
            setMYtimer(timeValue, true)
        }
    })
    //城市选择确定
    setSure2.addEventListener('click', async function () {
        let data = await chrome.storage.local.get("cityData")
        console.log(data.cityData)
        let cityValue1 = document.getElementById('set-cityChange').getElementsByClassName("select1")[0].getAttribute('value')
        let cityValue2 = document.getElementById('set-cityChange').getElementsByClassName("select2")[0].getAttribute('value')
        if (cityValue1 == '全国随机' || cityValue1 == '') {
            cityValue1 = ''
            cityValue2 = ''
        }
        if (cityValue1 && cityValue1 != '全国随机' && (cityValue2 == '全省随机' || cityValue2 == '')) {
            cityValue2 = []
            data.cityData.forEach((item) => {
                if (item.value == cityValue1) {
                    item.children.forEach((child) => {
                        cityValue2.push(child.value)
                    })
                }
            })
            cityValue2 = cityValue2.join(',')
        }
        let cityValue = {
            cityValue1: cityValue1,
            cityValue2: cityValue2
        }
        setMYcity(cityValue, true)
    })
    //取消定数设置
    setCancel.addEventListener('click', function () {
        setAlarms.style.display = 'none'
    })
    //取消城市设置
    setCancel2.addEventListener('click', function () {
        setCity.style.display = 'none'
    })
    //Load stored proxy settings
    ipBreak.addEventListener('click', function () {
        setClear()
        setTimeout(() => {
            showMessage('已断开链接')
            chrome.storage.local.remove("ip_addrName")
            getIps(backendExtUrl)
            nodeIPtxt.style.display = "black";
            nodeIPtxt.innerHTML = '本机'
            initPage("page-user")
        }, 300)
    });
});