function initTrack$$module$track(a, b) {
    console.log(`initTrack: ${a.constructor.name} ${b}`);
    return new Track$$module$track(a,b)
}
class Track$$module$track {
    constructor(a, b) {
        this.stackName = "localTrackStack";
        this.stackMax = 100;
        this.browser = a;
        this.script = b
    }
    genTime() {
        return (new Date).toLocaleString()
    }
    genLog(a) {
        a = a.map(b => "object" === typeof b ? JSON.stringify(b) : b).join(" ");
        return `[${this.genTime()}] ${this.script} ${a}`
    }
    async set(a, b) {
        if (b) {
            var c = await this.get();
            c.push({
                type: a,
                info: b
            });
            await this.browser.setStorageItem(this.stackName, JSON.stringify(c.slice(0, this.stackMax)))
        }
    }
    async get() {
        let a = await this.browser.getStorageItem(this.stackName);
        return a = a ? JSON.parse(a) : []
    }
    async clear() {
        await this.browser.setStorageItem(this.stackName, JSON.stringify([]))
    }
    log(...a) {
        a = this.genLog(a);
        console.log(a)
    }
    warn(...a) {
        for (let b = 0; b < a.length; b++)
            a[b]?.bgSync && delete a[b].bgSync,
            a[b]?.data?.bgSync && delete a[b].data.bgSync;
        a = this.genLog(a);
        this.set("warn", a);
        console.log(a)
    }
    error(...a) {
        for (let b = 0; b < a.length; b++)
            a[b]?.bgSync && delete a[b].bgSync,
            a[b]?.data?.bgSync && delete a[b].data.bgSync;
        a = this.genLog(a);
        this.set("error", a);
        console.log(a)
    }
}
var $jscompDefaultExport$$module$track = {
    init: initTrack$$module$track
}
  , module$track = {};
module$track.default = $jscompDefaultExport$$module$track;
const extensionVersion$$module$config = "1.0.6"
  , targetBrowser$$module$config = "chrome"
  , DEBUG_DEV$$module$config = !1
  , LOGIN_SHARE$$module$config = !0;
let backendName$$module$config = "kuaidaili"
  , backendHome$$module$config = "https://www.kuaidaili.com/"
  , backendRegExp$$module$config = /^\w+\.kuaidaili\.(com|cn|net|com.cn)$/
  , backendRegExp2$$module$config = /\w+\.kuaidaili\.(com|cn|net|com.cn)/;
DEBUG_DEV$$module$config && (backendName$$module$config = "127.0.0.1",
backendHome$$module$config = "http://127.0.0.1:8011/",
backendRegExp$$module$config = /^127.0.0.1$/,
backendRegExp2$$module$config = /127.0.0.1/);
const backendWebUrl$$module$config = {
    Home: backendHome$$module$config,
    Register: `${backendHome$$module$config}regist/`,
    Vcode: `${backendHome$$module$config}sendvcode/`,
    ContractSite: `${backendHome$$module$config}contract/`,
    ContractPrivacy: `${backendHome$$module$config}law/`,
    Buy: `${backendHome$$module$config}cart/`,
    Renew: `${backendHome$$module$config}cart/`,
    BuyAps: `${backendHome$$module$config}cart?p=month&t=aps`,
    Promoter: `${backendHome$$module$config}cps/`,
    ControlCenter: `${backendHome$$module$config}uc/`,
    Welcome: `${backendHome$$module$config}extension/`
}
  , backendExtUrl$$module$config = {
    Login: `${backendHome$$module$config}ext/login/`,
    AutoLogin: `${backendHome$$module$config}ext/login/`,
    ShareLogin: `${backendHome$$module$config}ext/share_login/`,
    Logout: `${backendHome$$module$config}ext/logout/`,
    GetIpInfo: `${backendHome$$module$config}ext/ip_info/`,
    ProxyList: `${backendHome$$module$config}ext/proxy_list/`,
    ProxyConfig: `${backendHome$$module$config}ext/proxy_config/`,
    ProxyAlive: `${backendHome$$module$config}ext/proxy_alive/`,
    BugReport: `${backendHome$$module$config}ext/bug_report/`,
    CheckUpdate: `${backendHome$$module$config}ext/check_update/`,
    Update: `${backendHome$$module$config}extension/?download=1`,
    RefreshToken: `${backendHome$$module$config}ext/refresh_token/`,
    Upload: `${backendHome$$module$config}ext/upload/`
}
  , backendAppUrl$$module$config = {
    ApsList: `${backendHome$$module$config}ext/aps_list/`,
    ApsFavor: `${backendHome$$module$config}ext/aps_favor/`,
    ApsConnect: `${backendHome$$module$config}ext/aps_connect/`,
    ApsDisconnect: `${backendHome$$module$config}ext/aps_disconnect/`,
    ApsConns: `${backendHome$$module$config}ext/aps_conns/`
}
  , proxyBypassList$$module$config = ["localhost", "local", "127.0.0.1", "*.kuaidaili.com", "kuaidaili.com"]
  , ConnectStatus$$module$config = {
    disconnected: "0",
    connected: "1",
    connecting: "2"
};
class Response$$module$config {
    constructor(a=0, b="ok", c=null) {
        this.code = a;
        this.msg = b;
        this.data = c
    }
}
// const respWrapper$$module$config = a => async (...b) => new Response$$module$config(0,"respWrapper",await a(b))
//   , allCountries$$module$config = [{
//     n: "中国大陆",
//     i: "cn",
//     d: "86"
// }, {
//     n: "中国香港",
//     i: "hk",
//     d: "852"
// }, {
//     n: "中国澳门",
//     i: "mo",
//     d: "853"
// }, {
//     n: "中国台湾",
//     i: "tw",
//     d: "886"
// }, {
//     n: "افغانستان",
//     i: "af",
//     d: "93"
// }, {
//     n: "Åland",
//     i: "ax",
//     d: "358"
// }, {
//     n: "Shqipëri",
//     i: "al",
//     d: "355"
// }, {
//     n: "الجزائر",
//     i: "dz",
//     d: "213"
// }, {
//     n: "American Samoa",
//     i: "as",
//     d: "1684"
// }, {
//     n: "Andorra",
//     i: "ad",
//     d: "376"
// }, {
//     n: "Angola",
//     i: "ao",
//     d: "244"
// }, {
//     n: "Anguilla",
//     i: "ai",
//     d: "1264"
// }, {
//     n: "Antigua and Barbuda",
//     i: "ag",
//     d: "1268"
// }, {
//     n: "Argentina",
//     i: "ar",
//     d: "54"
// }, {
//     n: "Հայաստան",
//     i: "am",
//     d: "374"
// }, {
//     n: "Aruba",
//     i: "aw",
//     d: "297"
// }, {
//     n: "Australia",
//     i: "au",
//     d: "61"
// }, {
//     n: "Österreich",
//     i: "at",
//     d: "43"
// }, {
//     n: "Azərbaycan",
//     i: "az",
//     d: "994"
// }, {
//     n: "Bahamas",
//     i: "bs",
//     d: "1242"
// }, {
//     n: "البحرين",
//     i: "bh",
//     d: "973"
// }, {
//     n: "বাংলাদেশ",
//     i: "bd",
//     d: "880"
// }, {
//     n: "Barbados",
//     i: "bb",
//     d: "1246"
// }, {
//     n: "Беларусь",
//     i: "by",
//     d: "375"
// }, {
//     n: "België",
//     i: "be",
//     d: "32"
// }, {
//     n: "Belize",
//     i: "bz",
//     d: "501"
// }, {
//     n: "Bénin",
//     i: "bj",
//     d: "229"
// }, {
//     n: "Bermuda",
//     i: "bm",
//     d: "1441"
// }, {
//     n: "འབྲུག",
//     i: "bt",
//     d: "975"
// }, {
//     n: "Bolivia",
//     i: "bo",
//     d: "591"
// }, {
//     n: "Босна и Херцеговина",
//     i: "ba",
//     d: "387"
// }, {
//     n: "Botswana",
//     i: "bw",
//     d: "267"
// }, {
//     n: "Brasil",
//     i: "br",
//     d: "55"
// }, {
//     n: "British Indian Ocean Territory",
//     i: "io",
//     d: "246"
// }, {
//     n: "British Virgin Islands",
//     i: "vg",
//     d: "1284"
// }, {
//     n: "Brunei",
//     i: "bn",
//     d: "673"
// }, {
//     n: "България",
//     i: "bg",
//     d: "359"
// }, {
//     n: "Burkina Faso",
//     i: "bf",
//     d: "226"
// }, {
//     n: "Uburundi",
//     i: "bi",
//     d: "257"
// }, {
//     n: "កម្ពុជា",
//     i: "kh",
//     d: "855"
// }, {
//     n: "Cameroun",
//     i: "cm",
//     d: "237"
// }, {
//     n: "Canada",
//     i: "ca",
//     d: "1"
// }, {
//     n: "Kabu Verdi",
//     i: "cv",
//     d: "238"
// }, {
//     n: "Caribbean Netherlands",
//     i: "bq",
//     d: "5997"
// }, {
//     n: "Cayman Islands",
//     i: "ky",
//     d: "1345"
// }, {
//     n: "République centrafricaine",
//     i: "cf",
//     d: "236"
// }, {
//     n: "Tchad",
//     i: "td",
//     d: "235"
// }, {
//     n: "Chile",
//     i: "cl",
//     d: "56"
// }, {
//     n: "Christmas Island",
//     i: "cx",
//     d: "61"
// }, {
//     n: "Kepulauan Cocos (Keeling)",
//     i: "cc",
//     d: "61"
// }, {
//     n: "Colombia",
//     i: "co",
//     d: "57"
// }, {
//     n: "جزر القمر",
//     i: "km",
//     d: "269"
// }, {
//     n: "Jamhuri ya Kidemokrasia ya Kongo",
//     i: "cd",
//     d: "243"
// }, {
//     n: "Congo-Brazzaville",
//     i: "cg",
//     d: "242"
// }, {
//     n: "Cook Islands",
//     i: "ck",
//     d: "682"
// }, {
//     n: "Costa Rica",
//     i: "cr",
//     d: "506"
// }, {
//     n: "Côte d’Ivoire",
//     i: "ci",
//     d: "225"
// }, {
//     n: "Hrvatska",
//     i: "hr",
//     d: "385"
// }, {
//     n: "Cuba",
//     i: "cu",
//     d: "53"
// }, {
//     n: "Curaçao",
//     i: "cw",
//     d: "5999"
// }, {
//     n: "Κύπρος",
//     i: "cy",
//     d: "357"
// }, {
//     n: "Česká republika",
//     i: "cz",
//     d: "420"
// }, {
//     n: "Danmark",
//     i: "dk",
//     d: "45"
// }, {
//     n: "Djibouti",
//     i: "dj",
//     d: "253"
// }, {
//     n: "Dominica",
//     i: "dm",
//     d: "1767"
// }, {
//     n: "República Dominicana",
//     i: "do",
//     d: "1809"
// }, {
//     n: "Ecuador",
//     i: "ec",
//     d: "593"
// }, {
//     n: "مصر",
//     i: "eg",
//     d: "20"
// }, {
//     n: "El Salvador",
//     i: "sv",
//     d: "503"
// }, {
//     n: "Guinea Ecuatorial",
//     i: "gq",
//     d: "240"
// }, {
//     n: "Eritrea",
//     i: "er",
//     d: "291"
// }, {
//     n: "Eesti",
//     i: "ee",
//     d: "372"
// }, {
//     n: "Ethiopia",
//     i: "et",
//     d: "251"
// }, {
//     n: "Islas Malvinas",
//     i: "fk",
//     d: "500"
// }, {
//     n: "Føroyar",
//     i: "fo",
//     d: "298"
// }, {
//     n: "Fiji",
//     i: "fj",
//     d: "679"
// }, {
//     n: "Suomi",
//     i: "fi",
//     d: "358"
// }, {
//     n: "France",
//     i: "fr",
//     d: "33"
// }, {
//     n: "Guyane française",
//     i: "gf",
//     d: "594"
// }, {
//     n: "Polynésie française",
//     i: "pf",
//     d: "689"
// }, {
//     n: "Gabon",
//     i: "ga",
//     d: "241"
// }, {
//     n: "Gambia",
//     i: "gm",
//     d: "220"
// }, {
//     n: "საქართველო",
//     i: "ge",
//     d: "995"
// }, {
//     n: "Deutschland",
//     i: "de",
//     d: "49"
// }, {
//     n: "Gaana",
//     i: "gh",
//     d: "233"
// }, {
//     n: "Gibraltar",
//     i: "gi",
//     d: "350"
// }, {
//     n: "Ελλάδα",
//     i: "gr",
//     d: "30"
// }, {
//     n: "Kalaallit Nunaat",
//     i: "gl",
//     d: "299"
// }, {
//     n: "Grenada",
//     i: "gd",
//     d: "1473"
// }, {
//     n: "Guadeloupe",
//     i: "gp",
//     d: "590"
// }, {
//     n: "Guam",
//     i: "gu",
//     d: "1671"
// }, {
//     n: "Guatemala",
//     i: "gt",
//     d: "502"
// }, {
//     n: "Guernsey",
//     i: "gg",
//     d: "44"
// }, {
//     n: "Guinée",
//     i: "gn",
//     d: "224"
// }, {
//     n: "Guiné Bissau",
//     i: "gw",
//     d: "245"
// }, {
//     n: "Guyana",
//     i: "gy",
//     d: "592"
// }, {
//     n: "Haiti",
//     i: "ht",
//     d: "509"
// }, {
//     n: "Honduras",
//     i: "hn",
//     d: "504"
// }, {
//     n: "Magyarország",
//     i: "hu",
//     d: "36"
// }, {
//     n: "Ísland",
//     i: "is",
//     d: "354"
// }, {
//     n: "भारत",
//     i: "in",
//     d: "91"
// }, {
//     n: "Indonesia",
//     i: "id",
//     d: "62"
// }, {
//     n: "ایران",
//     i: "ir",
//     d: "98"
// }, {
//     n: "العراق",
//     i: "iq",
//     d: "964"
// }, {
//     n: "Ireland",
//     i: "ie",
//     d: "353"
// }, {
//     n: "Isle of Man",
//     i: "im",
//     d: "44"
// }, {
//     n: "ישראל",
//     i: "il",
//     d: "972"
// }, {
//     n: "Italia",
//     i: "it",
//     d: "39"
// }, {
//     n: "Jamaica",
//     i: "jm",
//     d: "1876"
// }, {
//     n: "日本",
//     i: "jp",
//     d: "81"
// }, {
//     n: "Jersey",
//     i: "je",
//     d: "44"
// }, {
//     n: "الأردن",
//     i: "jo",
//     d: "962"
// }, {
//     n: "Казахстан",
//     i: "kz",
//     d: "7"
// }, {
//     n: "Kenya",
//     i: "ke",
//     d: "254"
// }, {
//     n: "Kiribati",
//     i: "ki",
//     d: "686"
// }, {
//     n: "Kosovë",
//     i: "xk",
//     d: "377"
// }, {
//     n: "الكويت",
//     i: "kw",
//     d: "965"
// }, {
//     n: "Кыргызстан",
//     i: "kg",
//     d: "996"
// }, {
//     n: "ລາວ",
//     i: "la",
//     d: "856"
// }, {
//     n: "Latvija",
//     i: "lv",
//     d: "371"
// }, {
//     n: "لبنان",
//     i: "lb",
//     d: "961"
// }, {
//     n: "Lesotho",
//     i: "ls",
//     d: "266"
// }, {
//     n: "Liberia",
//     i: "lr",
//     d: "231"
// }, {
//     n: "ليبيا",
//     i: "ly",
//     d: "218"
// }, {
//     n: "Liechtenstein",
//     i: "li",
//     d: "423"
// }, {
//     n: "Lietuva",
//     i: "lt",
//     d: "370"
// }, {
//     n: "Luxembourg",
//     i: "lu",
//     d: "352"
// }, {
//     n: "Македонија",
//     i: "mk",
//     d: "389"
// }, {
//     n: "Madagasikara",
//     i: "mg",
//     d: "261"
// }, {
//     n: "Malawi",
//     i: "mw",
//     d: "265"
// }, {
//     n: "Malaysia",
//     i: "my",
//     d: "60"
// }, {
//     n: "Maldives",
//     i: "mv",
//     d: "960"
// }, {
//     n: "Mali",
//     i: "ml",
//     d: "223"
// }, {
//     n: "Malta",
//     i: "mt",
//     d: "356"
// }, {
//     n: "Marshall Islands",
//     i: "mh",
//     d: "692"
// }, {
//     n: "Martinique",
//     i: "mq",
//     d: "596"
// }, {
//     n: "موريتانيا",
//     i: "mr",
//     d: "222"
// }, {
//     n: "Moris",
//     i: "mu",
//     d: "230"
// }, {
//     n: "Mayotte",
//     i: "yt",
//     d: "262"
// }, {
//     n: "México",
//     i: "mx",
//     d: "52"
// }, {
//     n: "Micronesia",
//     i: "fm",
//     d: "691"
// }, {
//     n: "Republica Moldova",
//     i: "md",
//     d: "373"
// }, {
//     n: "Monaco",
//     i: "mc",
//     d: "377"
// }, {
//     n: "Монгол",
//     i: "mn",
//     d: "976"
// }, {
//     n: "Crna Gora",
//     i: "me",
//     d: "382"
// }, {
//     n: "Montserrat",
//     i: "ms",
//     d: "1664"
// }, {
//     n: "المغرب",
//     i: "ma",
//     d: "212"
// }, {
//     n: "Moçambique",
//     i: "mz",
//     d: "258"
// }, {
//     n: "မြန်မာ",
//     i: "mm",
//     d: "95"
// }, {
//     n: "Namibië",
//     i: "na",
//     d: "264"
// }, {
//     n: "Nauru",
//     i: "nr",
//     d: "674"
// }, {
//     n: "नेपाल",
//     i: "np",
//     d: "977"
// }, {
//     n: "Nederland",
//     i: "nl",
//     d: "31"
// }, {
//     n: "Nouvelle-Calédonie",
//     i: "nc",
//     d: "687"
// }, {
//     n: "New Zealand",
//     i: "nz",
//     d: "64"
// }, {
//     n: "Nicaragua",
//     i: "ni",
//     d: "505"
// }, {
//     n: "Nijar",
//     i: "ne",
//     d: "227"
// }, {
//     n: "Nigeria",
//     i: "ng",
//     d: "234"
// }, {
//     n: "Niue",
//     i: "nu",
//     d: "683"
// }, {
//     n: "Norfolk Island",
//     i: "nf",
//     d: "672"
// }, {
//     n: "조선 민주주의 인민 공화국",
//     i: "kp",
//     d: "850"
// }, {
//     n: "Northern Mariana Islands",
//     i: "mp",
//     d: "1670"
// }, {
//     n: "Norge",
//     i: "no",
//     d: "47"
// }, {
//     n: "عُمان",
//     i: "om",
//     d: "968"
// }, {
//     n: "پاکستان",
//     i: "pk",
//     d: "92"
// }, {
//     n: "Palau",
//     i: "pw",
//     d: "680"
// }, {
//     n: "فلسطين",
//     i: "ps",
//     d: "970"
// }, {
//     n: "Panamá",
//     i: "pa",
//     d: "507"
// }, {
//     n: "Papua New Guinea",
//     i: "pg",
//     d: "675"
// }, {
//     n: "Paraguay",
//     i: "py",
//     d: "595"
// }, {
//     n: "Perú",
//     i: "pe",
//     d: "51"
// }, {
//     n: "Philippines",
//     i: "ph",
//     d: "63"
// }, {
//     n: "Pitcairn Islands",
//     i: "pn",
//     d: "64"
// }, {
//     n: "Polska",
//     i: "pl",
//     d: "48"
// }, {
//     n: "Portugal",
//     i: "pt",
//     d: "351"
// }, {
//     n: "Puerto Rico",
//     i: "pr",
//     d: "1787"
// }, {
//     n: "قطر",
//     i: "qa",
//     d: "974"
// }, {
//     n: "La Réunion",
//     i: "re",
//     d: "262"
// }, {
//     n: "România",
//     i: "ro",
//     d: "40"
// }, {
//     n: "Россия",
//     i: "ru",
//     d: "7"
// }, {
//     n: "Rwanda",
//     i: "rw",
//     d: "250"
// }, {
//     n: "Saint-Barthélemy",
//     i: "bl",
//     d: "590"
// }, {
//     n: "Saint Helena",
//     i: "sh",
//     d: "290"
// }, {
//     n: "Saint Kitts and Nevis",
//     i: "kn",
//     d: "1869"
// }, {
//     n: "Saint Lucia",
//     i: "lc",
//     d: "1758"
// }, {
//     n: "partie française",
//     i: "mf",
//     d: "590"
// }, {
//     n: "Saint-Pierre-et-Miquelon",
//     i: "pm",
//     d: "508"
// }, {
//     n: "Saint Vincent and the Grenadines",
//     i: "vc",
//     d: "1784"
// }, {
//     n: "Samoa",
//     i: "ws",
//     d: "685"
// }, {
//     n: "San Marino",
//     i: "sm",
//     d: "378"
// }, {
//     n: "São Tomé e Príncipe",
//     i: "st",
//     d: "239"
// }, {
//     n: "المملكة العربية السعودية",
//     i: "sa",
//     d: "966"
// }, {
//     n: "Sénégal",
//     i: "sn",
//     d: "221"
// }, {
//     n: "Србија",
//     i: "rs",
//     d: "381"
// }, {
//     n: "Seychelles",
//     i: "sc",
//     d: "248"
// }, {
//     n: "Sierra Leone",
//     i: "sl",
//     d: "232"
// }, {
//     n: "Singapore",
//     i: "sg",
//     d: "65"
// }, {
//     n: "Sint Maarten",
//     i: "sx",
//     d: "1721"
// }, {
//     n: "Slovensko",
//     i: "sk",
//     d: "421"
// }, {
//     n: "Slovenija",
//     i: "si",
//     d: "386"
// }, {
//     n: "Solomon Islands",
//     i: "sb",
//     d: "677"
// }, {
//     n: "Soomaaliya",
//     i: "so",
//     d: "252"
// }, {
//     n: "South Africa",
//     i: "za",
//     d: "27"
// }, {
//     n: "South - Georgia&Sandwich Islands",
//     i: "gs",
//     d: "500"
// }, {
//     n: "대한민국",
//     i: "kr",
//     d: "82"
// }, {
//     n: "جنوب السودان",
//     i: "ss",
//     d: "211"
// }, {
//     n: "España",
//     i: "es",
//     d: "34"
// }, {
//     n: "ශ්රී ලංකාව",
//     i: "lk",
//     d: "94"
// }, {
//     n: "السودان",
//     i: "sd",
//     d: "249"
// }, {
//     n: "Suriname",
//     i: "sr",
//     d: "597"
// }, {
//     n: "Svalbard og Jan Mayen",
//     i: "sj",
//     d: "4779"
// }, {
//     n: "Swaziland",
//     i: "sz",
//     d: "268"
// }, {
//     n: "Sverige",
//     i: "se",
//     d: "46"
// }, {
//     n: "Schweiz",
//     i: "ch",
//     d: "41"
// }, {
//     n: "سوريا",
//     i: "sy",
//     d: "963"
// }, {
//     n: "Tajikistan",
//     i: "tj",
//     d: "992"
// }, {
//     n: "Tanzania",
//     i: "tz",
//     d: "255"
// }, {
//     n: "ไทย",
//     i: "th",
//     d: "66"
// }, {
//     n: "Timor-Leste",
//     i: "tl",
//     d: "670"
// }, {
//     n: "Togo",
//     i: "tg",
//     d: "228"
// }, {
//     n: "Tokelau",
//     i: "tk",
//     d: "690"
// }, {
//     n: "Tonga",
//     i: "to",
//     d: "676"
// }, {
//     n: "Trinidad and Tobago",
//     i: "tt",
//     d: "1868"
// }, {
//     n: "تونس",
//     i: "tn",
//     d: "216"
// }, {
//     n: "Türkiye",
//     i: "tr",
//     d: "90"
// }, {
//     n: "Turkmenistan",
//     i: "tm",
//     d: "993"
// }, {
//     n: "Turks and Caicos Islands",
//     i: "tc",
//     d: "1649"
// }, {
//     n: "Tuvalu",
//     i: "tv",
//     d: "688"
// }, {
//     n: "Uganda",
//     i: "ug",
//     d: "256"
// }, {
//     n: "Україна",
//     i: "ua",
//     d: "380"
// }, {
//     n: "الإمارات العربية المتحدة",
//     i: "ae",
//     d: "971"
// }, {
//     n: "英国",
//     i: "gb",
//     d: "44"
// }, {
//     n: "美国",
//     i: "us",
//     d: "1"
// }, {
//     n: "U.S. Virgin Islands",
//     i: "vi",
//     d: "1340"
// }, {
//     n: "Uruguay",
//     i: "uy",
//     d: "598"
// }, {
//     n: "Oʻzbekiston",
//     i: "uz",
//     d: "998"
// }, {
//     n: "Vanuatu",
//     i: "vu",
//     d: "678"
// }, {
//     n: "Città del Vaticano",
//     i: "va",
//     d: "379"
// }, {
//     n: "Venezuela",
//     i: "ve",
//     d: "58"
// }, {
//     n: "Việt Nam",
//     i: "vn",
//     d: "84"
// }, {
//     n: "Wallis and Futuna",
//     i: "wf",
//     d: "681"
// }, {
//     n: "الصحراء الغربية",
//     i: "eh",
//     d: "212"
// }, {
//     n: "اليمن",
//     i: "ye",
//     d: "967"
// }, {
//     n: "Zambia",
//     i: "zm",
//     d: "260"
// }, {
//     n: "Zimbabwe",
//     i: "zw",
//     d: "263"
// }];
function genTelLi$$module$config() {
    const a = [];
    allCountries$$module$config.forEach( (b, c) => a.push(`<li data-dial-value="${b.d}" data-iso2-value="${b.i}"><span>${b.n}</span>${b.d}</li>`));
    return a.join("")
}
const regAlnum$$module$config = /[0-9a-zA-Z]/
  , chaosAlnumDict$$module$config = {
    0: "0",
    1: "9",
    2: "8",
    3: "7",
    4: "6",
    5: "5",
    6: "4",
    7: "3",
    8: "2",
    9: "1",
    a: "Z",
    b: "C",
    c: "D",
    d: "E",
    e: "F",
    f: "G",
    g: "I",
    h: "K",
    i: "L",
    j: "M",
    k: "N",
    l: "o",
    m: "P",
    n: "Q",
    o: "R",
    p: "S",
    q: "t",
    r: "u",
    s: "V",
    t: "w",
    u: "X",
    v: "Y",
    w: "z",
    x: "A",
    y: "B",
    z: "H",
    A: "J",
    B: "O",
    C: "T",
    D: "U",
    E: "W",
    F: "a",
    G: "b",
    H: "c",
    I: "d",
    J: "e",
    K: "f",
    L: "g",
    M: "h",
    N: "i",
    O: "j",
    P: "k",
    Q: "l",
    R: "m",
    S: "n",
    T: "p",
    U: "q",
    V: "r",
    W: "s",
    X: "v",
    Y: "x",
    Z: "y"
}
  , MD5$$module$config = a => MDT_M$$module$config(MD5_V$$module$config(MD5_Y$$module$config(MD5_X$$module$config(a), 8 * a.length))).toLowerCase()
  , MDT_M$$module$config = a => {
    let b = ""
      , c = 0;
    for (let d; c < a.length; c++)
        d = a.charCodeAt(c),
        b += "0123456789ABCDEF".charAt(d >>> 4 & 15) + "0123456789ABCDEF".charAt(15 & d);
    return b
}
  , MD5_X$$module$config = a => {
    let b = Array(a.length >> 2);
    for (var c = 0; c < b.length; c++)
        b[c] = 0;
    for (c = 0; c < 8 * a.length; c += 8)
        b[c >> 5] |= (255 & a.charCodeAt(c / 8)) << c % 32;
    return b
}
  , MD5_V$$module$config = a => {
    let b = "";
    for (let c = 0; c < 32 * a.length; c += 8)
        b += String.fromCharCode(a[c >> 5] >>> c % 32 & 255);
    return b
}
  , MD5_Y$$module$config = (a, b) => {
    const c = (e, p, q, r, t, u) => {
        e = n(n(p, e), n(r, u));
        return n(e << t | e >>> 32 - t, q)
    }
      , d = (e, p, q, r, t, u, v) => c(p & q | ~p & r, e, p, t, u, v)
      , k = (e, p, q, r, t, u, v) => c(p & r | q & ~r, e, p, t, u, v)
      , l = (e, p, q, r, t, u, v) => c(p ^ q ^ r, e, p, t, u, v)
      , m = (e, p, q, r, t, u, v) => c(q ^ (p | ~r), e, p, t, u, v)
      , n = (e, p) => {
        let q = (65535 & e) + (65535 & p);
        return (e >> 16) + (p >> 16) + (q >> 16) << 16 | 65535 & q
    }
    ;
    a[b >> 5] |= 128 << b % 32;
    a[14 + (b + 64 >>> 9 << 4)] = b;
    b = 1732584193;
    let h = -271733879
      , g = -1732584194
      , f = 271733878;
    for (let e = 0; e < a.length; e += 16) {
        let p = b
          , q = h
          , r = g
          , t = f;
        h = m(h = m(h = m(h = m(h = l(h = l(h = l(h = l(h = k(h = k(h = k(h = k(h = d(h = d(h = d(h = d(h, g = d(g, f = d(f, b = c(h & g | ~h & f, b, h, a[e + 0], 7, -680876936), h, g, a[e + 1], 12, -389564586), b, h, a[e + 2], 17, 606105819), f, b, a[e + 3], 22, -1044525330), g = d(g, f = d(f, b = c(h & g | ~h & f, b, h, a[e + 4], 7, -176418897), h, g, a[e + 5], 12, 1200080426), b, h, a[e + 6], 17, -1473231341), f, b, a[e + 7], 22, -45705983), g = d(g, f = d(f, b = c(h & g | ~h & f, b, h, a[e + 8], 7, 1770035416), h, g, a[e + 9], 12, -1958414417), b, h, a[e + 10], 17, -42063), f, b, a[e + 11], 22, -1990404162), g = d(g, f = d(f, b = c(h & g | ~h & f, b, h, a[e + 12], 7, 1804603682), h, g, a[e + 13], 12, -40341101), b, h, a[e + 14], 17, -1502002290), f, b, a[e + 15], 22, 1236535329), g = k(g, f = k(f, b = c(h & f | g & ~f, b, h, a[e + 1], 5, -165796510), h, g, a[e + 6], 9, -1069501632), b, h, a[e + 11], 14, 643717713), f, b, a[e + 0], 20, -373897302), g = k(g, f = k(f, b = c(h & f | g & ~f, b, h, a[e + 5], 5, -701558691), h, g, a[e + 10], 9, 38016083), b, h, a[e + 15], 14, -660478335), f, b, a[e + 4], 20, -405537848), g = k(g, f = k(f, b = c(h & f | g & ~f, b, h, a[e + 9], 5, 568446438), h, g, a[e + 14], 9, -1019803690), b, h, a[e + 3], 14, -187363961), f, b, a[e + 8], 20, 1163531501), g = k(g, f = k(f, b = c(h & f | g & ~f, b, h, a[e + 13], 5, -1444681467), h, g, a[e + 2], 9, -51403784), b, h, a[e + 7], 14, 1735328473), f, b, a[e + 12], 20, -1926607734), g = l(g, f = l(f, b = c(h ^ g ^ f, b, h, a[e + 5], 4, -378558), h, g, a[e + 8], 11, -2022574463), b, h, a[e + 11], 16, 1839030562), f, b, a[e + 14], 23, -35309556), g = l(g, f = l(f, b = c(h ^ g ^ f, b, h, a[e + 1], 4, -1530992060), h, g, a[e + 4], 11, 1272893353), b, h, a[e + 7], 16, -155497632), f, b, a[e + 10], 23, -1094730640), g = l(g, f = l(f, b = c(h ^ g ^ f, b, h, a[e + 13], 4, 681279174), h, g, a[e + 0], 11, -358537222), b, h, a[e + 3], 16, -722521979), f, b, a[e + 6], 23, 76029189), g = l(g, f = l(f, b = c(h ^ g ^ f, b, h, a[e + 9], 4, -640364487), h, g, a[e + 12], 11, -421815835), b, h, a[e + 15], 16, 530742520), f, b, a[e + 2], 23, -995338651), g = m(g, f = m(f, b = c(g ^ (h | ~f), b, h, a[e + 0], 6, -198630844), h, g, a[e + 7], 10, 1126891415), b, h, a[e + 14], 15, -1416354905), f, b, a[e + 5], 21, -57434055), g = m(g, f = m(f, b = c(g ^ (h | ~f), b, h, a[e + 12], 6, 1700485571), h, g, a[e + 3], 10, -1894986606), b, h, a[e + 10], 15, -1051523), f, b, a[e + 1], 21, -2054922799), g = m(g, f = m(f, b = c(g ^ (h | ~f), b, h, a[e + 8], 6, 1873313359), h, g, a[e + 15], 10, -30611744), b, h, a[e + 6], 15, -1560198380), f, b, a[e + 13], 21, 1309151649), g = m(g, f = m(f, b = c(g ^ (h | ~f), b, h, a[e + 4], 6, -145523070), h, g, a[e + 11], 10, -1120210379), b, h, a[e + 2], 15, 718787259), f, b, a[e + 9], 21, -343485551);
        b = n(b, p);
        h = n(h, q);
        g = n(g, r);
        f = n(f, t)
    }
    return [b, h, g, f]
}
  , sleep$$module$config = a => new Promise(b => setTimeout(b, a))
  , chaos$$module$config = a => regAlnum$$module$config.test(a) ? chaosAlnumDict$$module$config[a] : a
  , patch$$module$config = () => {
    Object.isEmpty = a => a && "{}" !== JSON.stringify(a) ? !1 : !0
}
;
var $jscompDefaultExport$$module$config = {
    extensionVersion: extensionVersion$$module$config,
    targetBrowser: targetBrowser$$module$config,
    DEBUG_DEV: DEBUG_DEV$$module$config,
    LOGIN_SHARE: LOGIN_SHARE$$module$config,
    backendName: backendName$$module$config,
    backendHome: backendHome$$module$config,
    backendRegExp: backendRegExp$$module$config,
    backendRegExp2: backendRegExp2$$module$config,
    backendWebUrl: backendWebUrl$$module$config,
    backendExtUrl: backendExtUrl$$module$config,
    backendAppUrl: backendAppUrl$$module$config,
    proxyBypassList: proxyBypassList$$module$config,
    ConnectStatus: ConnectStatus$$module$config,
    allCountries: allCountries$$module$config,
    MD5: MD5$$module$config,
    sleep: sleep$$module$config,
    chaos: chaos$$module$config,
    patch: patch$$module$config,
    genTelLi: genTelLi$$module$config,
    Response: Response$$module$config,
    respWrapper: respWrapper$$module$config
}
  , module$config = {};
module$config.default = $jscompDefaultExport$$module$config;
const wrapperVersion$$module$extension = "0.0.1";
function initBrowser$$module$extension(a) {
    a = a.toLowerCase();
    let b = Chrome$$module$extension;
    a.startsWith("chrome") && (b = Chrome$$module$extension);
    a.startsWith("edge") && (b = Edge$$module$extension);
    a.startsWith("firefox") && (b = Firefox$$module$extension);
    console.log(`(${wrapperVersion$$module$extension}) initBrowser: ${b.name}`);
    return new b
}
class Browser$$module$extension {
    constructor() {
        this.event = new BrowserEvent$$module$extension
    }
}
class Chrome$$module$extension extends Browser$$module$extension {
    constructor() {
        super();
        this.event = new ChromeEvent$$module$extension
    }
    getMessage(a) {
        return chrome.i18n.getMessage(a)
    }
    async setIcon(a, b) {
        a && await chrome.action.setIcon({
            path: a
        });
        b && await chrome.action.setTitle({
            title: b
        })
    }
    async createTab(a) {
        await chrome.tabs.create(a)
    }
    async setUninstallUrl(a) {
        await chrome.runtime.setUninstallURL(a)
    }
    async getPlatformInfo() {
        return await chrome.runtime.getPlatformInfo()
    }
    async getStorageItem(a, b) {
        null === a ? a = await chrome.storage.local.get(null) : "object" === typeof a ? (b = await chrome.storage.local.get(Object.keys(a)),
        a = Object.assign(a, b)) : a = (await chrome.storage.local.get([a]))?.[a] || b || "";
        return a
    }
    async setStorageItem(a, b, c) {
        let d = {};
        "object" === typeof a ? d = a : d[a] = b;
        await chrome.storage.local.set(d);
        c && Object.assign(c, d)
    }
    async clearStorageItem() {
        await chrome.storage.local.clear()
    }
    async clearAlarm(a) {
        await chrome.alarms.clear(a)
    }
    async createAlarm(a, b) {
        await chrome.alarms.create(a, b)
    }
    async updateDynamicRules(a) {
        await chrome.declarativeNetRequest.updateDynamicRules(a)
    }
    async getCookies(a={}) {
        return await chrome.cookies.getAll(a)
    }
    async removeCookie(a) {
        a && await chrome.cookies.remove({
            name: a.name,
            url: `${a.secure ? "https:" : "http:"}//${a.domain}${a.path}`,
            storeId: a.storeId
        })
    }
    async removeCookies(a) {
        if (a) {
            var b = [];
            a.forEach(c => {
                b.push(this.removeCookie(c))
            }
            );
            await Promise.all(b)
        }
    }
    async clearProxySettings(a) {
        await chrome.proxy.settings.clear(a)
    }
    async setProxySettings(a) {
        await chrome.proxy.settings.set(a)
    }
    async getProxySettings(a) {
        return await chrome.proxy.settings.get(a)
    }
    async removeBrowsingData(a, b) {
        await chrome.browsingData.remove(a, b)
    }
    async getShortcuts() {
        return await chrome.commands.getAll()
    }
    async checkProxyControl() {
        const a = await this.getProxySettings({
            incognito: !1
        });
        return ["controllable_by_this_extension", "controlled_by_this_extension"].includes(a.levelOfControl)
    }
    async checkBlockHeader() {
        return !0
    }
    async checkCommandShortcuts() {
        const a = this.getShortcuts()
          , b = [];
        for (let {name: c, shortcut: d} of a)
            "" === d && b.push(c);
        return b
    }
}
class Edge$$module$extension extends Chrome$$module$extension {
    constructor() {
        super();
        this.event = new EdgeEvent$$module$extension
    }
}
class Firefox$$module$extension extends Browser$$module$extension {
    constructor() {
        super();
        this.event = new FirefoxEvent$$module$extension
    }
}
class BrowserEvent$$module$extension {
    constructor() {}
}
class ChromeEvent$$module$extension extends BrowserEvent$$module$extension {
    constructor() {
        super();
        this.conf = {
            installedReason: {
                INSTALL: chrome.runtime.OnInstalledReason.INSTALL
            }
        }
    }
    get onBeforeRequest() {
        return chrome.webRequest.onBeforeRequest
    }
    get onAuthRequired() {
        return chrome.webRequest.onAuthRequired
    }
    get onProxyError() {
        return chrome.proxy.onProxyError
    }
    get onAlarm() {
        return chrome.alarms.onAlarm
    }
    get onInstalled() {
        return chrome.runtime.onInstalled
    }
    get onStorageChanged() {
        return chrome.storage.onChanged
    }
}
class EdgeEvent$$module$extension extends ChromeEvent$$module$extension {
}
class FirefoxEvent$$module$extension extends BrowserEvent$$module$extension {
}
var $jscompDefaultExport$$module$extension = {
    wrapper: {
        version: wrapperVersion$$module$extension
    },
    init: initBrowser$$module$extension
}
  , module$extension = {};
module$extension.default = $jscompDefaultExport$$module$extension;
const {extensionVersion: extensionVersion$$module$popup_original, targetBrowser: targetBrowser$$module$popup_original, DEBUG_DEV: DEBUG_DEV$$module$popup_original, LOGIN_SHARE: LOGIN_SHARE$$module$popup_original, backendWebUrl: backendWebUrl$$module$popup_original, backendExtUrl: backendExtUrl$$module$popup_original, backendAppUrl: backendAppUrl$$module$popup_original, ConnectStatus: ConnectStatus$$module$popup_original, sleep: sleep$$module$popup_original, chaos: chaos$$module$popup_original, patch: patch$$module$popup_original, genTelLi: genTelLi$$module$popup_original, Response: Response$$module$popup_original} = $jscompDefaultExport$$module$config;
patch$$module$popup_original();
const browser$$module$popup_original = $jscompDefaultExport$$module$extension.init(targetBrowser$$module$popup_original)
  , track$$module$popup_original = $jscompDefaultExport$$module$track.init(browser$$module$popup_original, "<popup.js>")
  , _$$module$popup_original = a => browser$$module$popup_original.getMessage(a)
  , getLoginToken$$module$popup_original = async () => await browser$$module$popup_original.getStorageItem("loginToken")
  , getRefreshToken$$module$popup_original = async () => await browser$$module$popup_original.getStorageItem("refreshToken")
  , updateLastPopupTime$$module$popup_original = async () => await browser$$module$popup_original.setStorageItem("lastPopupTime", +new Date, cache$$module$popup_original)
  , updateBrowserInfo$$module$popup_original = async () => await browser$$module$popup_original.setStorageItem("browserInfo", getBrowserInfo$$module$popup_original())
  , updatePlatformInfo$$module$popup_original = async () => await browser$$module$popup_original.setStorageItem("platformInfo", await getPlatformInfo$$module$popup_original());
async function background$$module$popup_original(a) {
    let b = function(k) {
        return "back" + k[0].toUpperCase() + k.slice(1)
    }(a.back)
      , c = function(k) {
        return "echoBack" + k[0].toUpperCase() + k.slice(1)
    }(a.back);
    a.echoKey = c;
    const d = {};
    d[b] = function(k) {
        k.timestamp = (+new Date).toString() + Math.random();
        return JSON.stringify(k)
    }(a);
    d[c] = "";
    await browser$$module$popup_original.setStorageItem(d);
    return await waitBackground$$module$popup_original(c)
}
async function waitBackground$$module$popup_original(a) {
    async function b() {
        if (DEBUG_DEV$$module$popup_original && 50 <= c || 100 <= c)
            return new Response$$module$popup_original(100300,"background timeout");
        await sleep$$module$popup_original(100);
        c++;
        const k = await browser$$module$popup_original.getStorageItem(a);
        return k ? k : b()
    }
    let c = 0
      , d = await b();
    d || (track$$module$popup_original.error("waitBackground response empty, echoKey:", a),
    d = new Response$$module$popup_original(100301,"background response empty"));
    return d instanceof Response$$module$popup_original ? bgResponseHandler$$module$popup_original(d) : bgResponseHandler$$module$popup_original(JSON.parse(d))
}
function bgResponseHandler$$module$popup_original(a) {
    a?.data?.bgSync && Object.assign(cache$$module$popup_original, a.data.bgSync);
    if (0 === a.code)
        return a;
    track$$module$popup_original.warn("bgResponseHandler code !0:", a);
    recoverChanges$$module$popup_original();
    switch (a.code) {
    case 1E5:
        return showMessage$$module$popup_original({
            showTime: 1E4,
            status: _$$module$popup_original("errProxyPermission")
        });
    case 100001:
        return showMessage$$module$popup_original({
            showTime: 1E4,
            status: _$$module$popup_original("errHeaderPermission")
        });
    case 100002:
        break;
    case 100100:
        return showMessage$$module$popup_original(_$$module$popup_original("tipClearCookiesFailed"));
    case 100101:
        break;
    case 100200:
        return httpErrorHandler$$module$popup_original(a.data);
    case 100201:
        return jsonErrorHandler$$module$popup_original(a.data);
    case 100202:
        return a.data;
    case 100203:
        return httpErrorHandler$$module$popup_original(a.data);
    case 100204:
        return showMessage$$module$popup_original(a.msg);
    case 100205:
        return showMessage$$module$popup_original(a.msg);
    case 100206:
        return showMessage$$module$popup_original(a.msg);
    case 100207:
        return showMessage$$module$popup_original(a.msg);
    case 100208:
        return showMessage$$module$popup_original(a.msg);
    case 100300:
        return showMessage$$module$popup_original(a.msg);
    case 100301:
        return showMessage$$module$popup_original(a.msg);
    default:
        return a
    }
}
async function getPlatformInfo$$module$popup_original() {
    let a = await browser$$module$popup_original.getPlatformInfo();
    a ||= {
        os: "unknown"
    };
    return a.os + " " + (a.arch === a.nacl_arch ? a.arch : `${a.arch}/${a.nacl_arch}`)
}
function getBrowserInfo$$module$popup_original() {
    var a, b, c, d, k;
    let l;
    const m = navigator.userAgent.toLowerCase();
    (l = m.match(/edge\/([\d\.]+)/)) ? a = l[1] : (l = m.match(/edg\/([\d\.]+)/)) ? a = l[1] : (l = m.match(/firefox\/([\d\.]+)/)) ? b = l[1] : (l = m.match(/chrome\/([\d\.]+)/)) ? c = l[1] : (l = m.match(/opera.([\d\.]+)/)) ? d = l[1] : (l = m.match(/version\/([\d\.]+).*safari/)) ? k = l[1] : 0;
    return a ? `Edge/${a}` : b ? `Firefox/${b}` : c ? `Chrome/${c}` : d ? `Opera/${d}` : k ? `Safari/${k}` : "Unknown/Unknown"
}
async function getTargetDomain$$module$popup_original() {
    const a = await background$$module$popup_original({
        back: "getLastRequestDomain",
        args: [1]
    });
    if (a)
        return a.data.length ? a.data[0].url : _$$module$popup_original("tipProxyHistoryNotExist")
}
async function clearCookies$$module$popup_original() {
    if (await background$$module$popup_original({
        back: "clearCookies"
    }))
        return showMessage$$module$popup_original(_$$module$popup_original("tipClearCookiesSuccess"))
}
const nodePopupLogin$$module$popup_original = document.getElementById("popup-login")
  , nodePopupMain$$module$popup_original = document.getElementById("popup-main")
  , nodePageLogin$$module$popup_original = document.getElementById("page-login")
  , pageAutoLogin$$module$popup_original = document.getElementById("page-auto-login")
  , nodePageConnect$$module$popup_original = document.getElementById("page-connect")
  , nodePageList$$module$popup_original = document.getElementById("page-list")
  , nodePageOption$$module$popup_original = document.getElementById("page-option")
  , nodePageBugReport$$module$popup_original = document.getElementById("page-bug-report")
  , pageFromId$$module$popup_original = {
    "popup-login": nodePopupLogin$$module$popup_original,
    "popup-main": nodePopupMain$$module$popup_original,
    "page-login": nodePageLogin$$module$popup_original,
    "page-auto-login": pageAutoLogin$$module$popup_original,
    "page-connect": nodePageConnect$$module$popup_original,
    "page-list": nodePageList$$module$popup_original,
    "page-option": nodePageOption$$module$popup_original,
    "page-bug-report": nodePageBugReport$$module$popup_original
}
  , allPages$$module$popup_original = Object.values(pageFromId$$module$popup_original)
  , nodeLoginMethodMobile$$module$popup_original = nodePageLogin$$module$popup_original.getElementsByClassName("login-method-mobile")[0]
  , nodeLoginMethodWxQrcode$$module$popup_original = nodePageLogin$$module$popup_original.getElementsByClassName("login-method-wx-qrcode")[0]
  , nodeLoginMethodInfo$$module$popup_original = nodePageLogin$$module$popup_original.getElementsByClassName("login-method-info")[0]
  , nodeOtherLoginMethod$$module$popup_original = nodePageLogin$$module$popup_original.getElementsByClassName("other-login-method")[0]
  , nodeOtherLoginMethodInfo$$module$popup_original = nodeOtherLoginMethod$$module$popup_original.getElementsByClassName("other-login-method-info")[0]
  , nodeSendVcodeButton$$module$popup_original = document.getElementById("sendvcode_btn")
  , nodeInputMobile$$module$popup_original = document.getElementById("input-mobile")
  , nodeInputVerifyCode$$module$popup_original = document.getElementById("input-verify-code")
  , nodeLoginButton$$module$popup_original = document.getElementById("input-login")
  , nodeImgWxQrcode$$module$popup_original = document.getElementById("img-wx-qrcode")
  , nodeRegisterButton$$module$popup_original = nodePageLogin$$module$popup_original.getElementsByClassName("register")[0]
  , nodeDivideLineTip$$module$popup_original = nodePageLogin$$module$popup_original.getElementsByClassName("divide-line-tip")[0]
  , nodeMobileLabel$$module$popup_original = nodePageLogin$$module$popup_original.getElementsByTagName("label")[0]
  , nodeVerifyCodeLabel$$module$popup_original = nodePageLogin$$module$popup_original.getElementsByTagName("label")[1]
  , nodeContractInfo$$module$popup_original = nodePageLogin$$module$popup_original.getElementsByClassName("contract-info")
  , nodeTelCDate$$module$popup_original = document.getElementById("tel-c-data")
  , nodeAutoLoginButton$$module$popup_original = document.getElementById("auto-login")
  , nodeAutoOtherLoginMethod$$module$popup_original = pageAutoLogin$$module$popup_original.getElementsByClassName("other-login-method")[0]
  , nodeHeaderLogin$$module$popup_original = nodePopupLogin$$module$popup_original.getElementsByTagName("header")[0]
  , nodeHeaderMiddle$$module$popup_original = nodePopupMain$$module$popup_original.getElementsByClassName("header-middle")[0]
  , nodeHeaderLeft$$module$popup_original = nodePopupMain$$module$popup_original.getElementsByClassName("header-left")[0]
  , nodeHeaderRight$$module$popup_original = nodePopupMain$$module$popup_original.getElementsByClassName("header-right")[0]
  , nodeIpInfoPanel$$module$popup_original = nodePageConnect$$module$popup_original.getElementsByClassName("ip-info-panel")[0]
  , nodeIpShow$$module$popup_original = document.getElementById("ip-show")
  , nodeToggleIpShow$$module$popup_original = document.getElementById("toggle-ip-show")
  , nodeIpLocation$$module$popup_original = document.getElementById("ip-location")
  , nodeIpProvider$$module$popup_original = document.getElementById("ip-provider")
  , nodeRefreshIpButton$$module$popup_original = document.getElementById("refresh-ip")
  , nodeToggleIpButton$$module$popup_original = document.getElementById("toggle-ip")
  , nodeHeadPics$$module$popup_original = nodePopupMain$$module$popup_original.getElementsByClassName("head-pic-wrap")
  , nodeAppInfoPanel$$module$popup_original = nodePageConnect$$module$popup_original.getElementsByClassName("app-info-panel")[0]
  , nodeAppShowInfo$$module$popup_original = document.getElementById("app-show-info")
  , nodeAppShow$$module$popup_original = document.getElementById("app-show")
  , nodeAppInfoPanelIconDelay$$module$popup_original = nodeAppInfoPanel$$module$popup_original.getElementsByClassName("icon-delay")[0]
  , nodeAppInfoPanelDelay$$module$popup_original = nodeAppInfoPanel$$module$popup_original.getElementsByClassName("aps-city-delay")[0]
  , nodeConnectButton$$module$popup_original = nodePageConnect$$module$popup_original.getElementsByClassName("connect-button-wrap")[0]
  , nodeConnectStatus$$module$popup_original = nodeConnectButton$$module$popup_original.getElementsByClassName("connect-status")[0]
  , nodeConnectBall$$module$popup_original = nodeConnectButton$$module$popup_original.getElementsByClassName("connect-button-ball")[0]
  , nodeConnectInfo$$module$popup_original = nodePageConnect$$module$popup_original.getElementsByClassName("connect-info")[0]
  , nodeConnectStar$$module$popup_original = nodePageConnect$$module$popup_original.getElementsByClassName("connect-star")[0]
  , connectButtonList$$module$popup_original = [nodeConnectButton$$module$popup_original, nodeConnectStatus$$module$popup_original, nodeConnectBall$$module$popup_original, nodeConnectStar$$module$popup_original]
  , nodeCurrentProxyPanel$$module$popup_original = nodePageConnect$$module$popup_original.getElementsByClassName("current-proxy-panel")[0]
  , nodeCurrentProxyImg$$module$popup_original = nodePageConnect$$module$popup_original.getElementsByClassName("current-proxy-img")[0]
  , nodeProxyShow$$module$popup_original = document.getElementById("proxy-show")
  , nodeProxySpec$$module$popup_original = document.getElementById("proxy-spec")
  , nodeOrderList$$module$popup_original = document.getElementById("order-list")
  , nodeApsList$$module$popup_original = document.getElementById("aps-list")
  , nodeSwitchListButton$$module$popup_original = document.getElementById("switch-list-button")
  , nodeSwitchApp$$module$popup_original = document.getElementById("switch-app")
  , nodeSwitchOrder$$module$popup_original = document.getElementById("switch-order")
  , nodeOrderListNone$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-list-none")[0]
  , nodeOrderListNoneTip$$module$popup_original = nodeOrderListNone$$module$popup_original.getElementsByTagName("p")[0]
  , nodeOrderTpsProWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-tps-pro-wrap")[0]
  , nodeOrderTpsWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-tps-wrap")[0]
  , nodeOrderLrpsWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-lrps-wrap")[0]
  , nodeOrderKpsWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-kps-wrap")[0]
  , nodeOrderFpsWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-fps-wrap")[0]
  , nodeOrderSfpsWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-sfps-wrap")[0]
  , nodeOrderTpsProOuterWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-tps-pro-outer-wrap")[0]
  , nodeOrderTpsOuterWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-tps-outer-wrap")[0]
  , nodeOrderLrpsOuterWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-lrps-outer-wrap")[0]
  , nodeOrderKpsOuterWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-kps-outer-wrap")[0]
  , nodeOrderFpsOuterWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-fps-outer-wrap")[0]
  , nodeOrderSfpsOuterWrap$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("order-sfps-outer-wrap")[0]
  , nodeOrderTitleTpsPro$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("title-order-tps-pro")[0]
  , nodeOrderTitleTps$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("title-order-tps")[0]
  , nodeOrderTitleLrps$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("title-order-lrps")[0]
  , nodeOrderTitleKps$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("title-order-kps")[0]
  , nodeOrderTitleFps$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("title-order-fps")[0]
  , nodeOrderTitleSfps$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("title-order-sfps")[0]
  , nodeForeignNetworkRequired$$module$popup_original = nodeOrderList$$module$popup_original.getElementsByClassName("foreign-network-required")
  , nodeAppListNone$$module$popup_original = nodeApsList$$module$popup_original.getElementsByClassName("app-list-none")[0]
  , nodeAppListNoneTip$$module$popup_original = nodeAppListNone$$module$popup_original.getElementsByTagName("p")[0]
  , nodeApsLatestWrap$$module$popup_original = nodeApsList$$module$popup_original.getElementsByClassName("aps-wrap-latest")[0]
  , nodeApsFavorWrap$$module$popup_original = nodeApsList$$module$popup_original.getElementsByClassName("aps-wrap-favor")[0]
  , nodeApsAllWrap$$module$popup_original = nodeApsList$$module$popup_original.getElementsByClassName("aps-all-wrap")[0]
  , nodeApsLatestOuterWrap$$module$popup_original = nodeApsList$$module$popup_original.getElementsByClassName("aps-latest-outer-wrap")[0]
  , nodeApsAllOuterWrap$$module$popup_original = nodeApsList$$module$popup_original.getElementsByClassName("aps-all-outer-wrap")[0]
  , nodeApsTitleWrap$$module$popup_original = nodeApsLatestOuterWrap$$module$popup_original.getElementsByClassName("title-wrap")[0]
  , nodeApsTitleLatest$$module$popup_original = nodeApsList$$module$popup_original.getElementsByClassName("title-aps-latest")[0]
  , nodeApsTitleFavor$$module$popup_original = nodeApsList$$module$popup_original.getElementsByClassName("title-aps-favor")[0]
  , nodeApsTitleAll$$module$popup_original = nodeApsList$$module$popup_original.getElementsByClassName("title-aps-all")[0]
  , nodeBuyButton$$module$popup_original = nodePageList$$module$popup_original.getElementsByClassName("buy-button")
  , nodeOptionBuy$$module$popup_original = nodePageOption$$module$popup_original.getElementsByClassName("option-buy")[0]
  , nodeOptionWebControl$$module$popup_original = nodePageOption$$module$popup_original.getElementsByClassName("option-web-control")[0]
  , nodeOptionPromoter$$module$popup_original = nodePageOption$$module$popup_original.getElementsByClassName("option-promoter")[0]
  , nodeOptionClearCookie$$module$popup_original = nodePageOption$$module$popup_original.getElementsByClassName("option-clear-cookie")[0]
  , nodeOptionBugReport$$module$popup_original = nodePageOption$$module$popup_original.getElementsByClassName("option-bug-report")[0]
  , nodeLogoutButton$$module$popup_original = document.getElementById("logout")
  , nodeOptionUserInfo$$module$popup_original = nodePageOption$$module$popup_original.getElementsByClassName("user-info")[0]
  , nodeExtensionInfo$$module$popup_original = nodePageBugReport$$module$popup_original.getElementsByClassName("extension-info")[0]
  , nodeContactMobile$$module$popup_original = document.getElementById("contact-mobile")
  , nodeContactQuestion$$module$popup_original = document.getElementById("contact-question")
  , nodeSubmitBugButton$$module$popup_original = document.getElementById("submit-bug")
  , nodeTemplateLogo$$module$popup_original = document.getElementById("template-logo").content.firstElementChild
  , nodeTemplateOrder$$module$popup_original = document.getElementById("template-order").content.firstElementChild
  , nodeTemplateApsRandom$$module$popup_original = document.getElementById("template-aps-random").content.firstElementChild
  , nodeTemplateApsProvince$$module$popup_original = document.getElementById("template-aps-province").content.firstElementChild
  , nodeTemplateApsCity$$module$popup_original = document.getElementById("template-aps-city").content.firstElementChild
  , nodeTemplateBack$$module$popup_original = document.getElementById("template-back").content.firstElementChild
  , nodeTemplateMessageHard$$module$popup_original = document.getElementById("template-popup-message-hard").content.firstElementChild
  , nodeTemplateMessageSoft$$module$popup_original = document.createElement("section")
  , classNameInputInvalid$$module$popup_original = "invalid"
  , classNameUserSelectNone$$module$popup_original = "usn"
  , classNameCurrentOrder$$module$popup_original = "current-order"
  , classNameAboutExpire$$module$popup_original = "about-expire"
  , classNameOnedayExpire$$module$popup_original = "oneday-expire"
  , loginMethodWxQrcodeId$$module$popup_original = "login-method-wx-qrcode"
  , loginMethodMobileId$$module$popup_original = "login-method-mobile"
  , imgProxyTpsPro$$module$popup_original = "/assets/img/current-proxy-tps-pro.png"
  , imgProxyTps$$module$popup_original = "/assets/img/current-proxy-tps.png"
  , imgProxyLrps$$module$popup_original = "/assets/img/current-proxy-lrps.png"
  , imgProxyKps$$module$popup_original = "/assets/img/current-proxy-kps.png"
  , imgProxyFps$$module$popup_original = "/assets/img/current-proxy-fps.png"
  , imgProxySfps$$module$popup_original = "/assets/img/current-proxy-sfps.png"
  , imgProxyAps$$module$popup_original = "/assets/img/current-proxy-aps.png";
for (let a = 0; a < nodeContractInfo$$module$popup_original.length; a++)
    nodeContractInfo$$module$popup_original[a].innerHTML = _$$module$popup_original("initContractInfo");
for (let a = 0; a < nodeBuyButton$$module$popup_original.length; a++)
    nodeBuyButton$$module$popup_original[a].innerHTML = _$$module$popup_original("initBuyButton");
for (let a = 0; a < nodeForeignNetworkRequired$$module$popup_original.length; a++)
    nodeForeignNetworkRequired$$module$popup_original[a].innerHTML = _$$module$popup_original("initForeignNetworkRequired");
nodeMobileLabel$$module$popup_original.innerText = _$$module$popup_original("initMobileLabel");
nodeVerifyCodeLabel$$module$popup_original.innerText = _$$module$popup_original("initVerifyCode");
nodeSendVcodeButton$$module$popup_original.innerText = _$$module$popup_original("initSendVcode");
nodeToggleIpShow$$module$popup_original.innerHTML = _$$module$popup_original("initToggleIpShow");
nodeAutoOtherLoginMethod$$module$popup_original.firstElementChild.innerHTML = _$$module$popup_original("initOtherLoginMethod");
nodeDivideLineTip$$module$popup_original.innerText = _$$module$popup_original("initOr");
nodeRegisterButton$$module$popup_original.innerText = _$$module$popup_original("initRegisterButton");
nodeConnectInfo$$module$popup_original.innerText = _$$module$popup_original("initConnectInfo");
nodeSwitchApp$$module$popup_original.innerHTML = _$$module$popup_original("initSwitchApp");
nodeSwitchOrder$$module$popup_original.innerHTML = _$$module$popup_original("initSwitchOrder");
nodeOrderTitleTpsPro$$module$popup_original.innerHTML = _$$module$popup_original("initTitleOrderTpsPro");
nodeOrderTitleTps$$module$popup_original.innerHTML = _$$module$popup_original("initTitleOrderTps");
nodeOrderTitleLrps$$module$popup_original.innerHTML = _$$module$popup_original("initTitleOrderLrps");
nodeOrderTitleKps$$module$popup_original.innerHTML = _$$module$popup_original("initTitleOrderKps");
nodeOrderTitleFps$$module$popup_original.innerHTML = _$$module$popup_original("initTitleOrderFps");
nodeOrderTitleSfps$$module$popup_original.innerHTML = _$$module$popup_original("initTitleOrderSfps");
nodeApsTitleLatest$$module$popup_original.innerHTML = _$$module$popup_original("initApsTitleLatest");
nodeApsTitleFavor$$module$popup_original.innerHTML = _$$module$popup_original("initApsTitleFavor");
nodeApsTitleAll$$module$popup_original.innerHTML = _$$module$popup_original("initApsTitleAll");
nodeAppListNoneTip$$module$popup_original.innerHTML = _$$module$popup_original("initAppListNone");
nodeOrderListNoneTip$$module$popup_original.innerHTML = _$$module$popup_original("initOrderListNone");
nodeOptionBuy$$module$popup_original.innerHTML = _$$module$popup_original("initOptionBuy");
nodeOptionWebControl$$module$popup_original.innerHTML = _$$module$popup_original("initOptionConnect");
nodeOptionPromoter$$module$popup_original.innerHTML = _$$module$popup_original("initOptionPromoter");
nodeOptionClearCookie$$module$popup_original.innerHTML = _$$module$popup_original("initOptionClearCookie");
nodeOptionBugReport$$module$popup_original.innerHTML = _$$module$popup_original("initOptionBugReport");
nodeExtensionInfo$$module$popup_original.innerHTML = _$$module$popup_original("initExtensionInfo");
nodeContactMobile$$module$popup_original.placeholder = _$$module$popup_original("initContactMobileTip");
nodeContactQuestion$$module$popup_original.placeholder = _$$module$popup_original("initContactQuestionTip");
nodeLoginButton$$module$popup_original.value = _$$module$popup_original("btnLogin");
nodeLogoutButton$$module$popup_original.firstElementChild.innerText = _$$module$popup_original("btnLogout");
nodeAutoLoginButton$$module$popup_original.firstElementChild.innerText = _$$module$popup_original("btnAutoLogin");
nodeSubmitBugButton$$module$popup_original.value = _$$module$popup_original("btnSubmit");
function showMessage$$module$popup_original(a) {
    const b = a?.status || a;
    if (b) {
        var c = a?.type || "soft"
          , d = null
          , k = 400;
        "soft" === c ? (closeSoftMessages$$module$popup_original(),
        d = nodeTemplateMessageSoft$$module$popup_original.cloneNode(!0)) : (k = 200,
        closeHardMessages$$module$popup_original(),
        d = nodeTemplateMessageHard$$module$popup_original.cloneNode(!0));
        d.closeSelf = function(m) {
            (m = parseInt(m) || 0) ? (setTimeout( () => this.style.opacity = "0", m),
            setTimeout( () => this.style.display = "none", m + k)) : (this.style.opacity = "0",
            setTimeout( () => this.style.display = "none", k))
        }
        ;
        document.body.append(d);
        d.classList.add(c);
        d.classList.add(classNameUserSelectNone$$module$popup_original);
        if ("soft" === c)
            d.classList.add("popup-message"),
            d.innerHTML = b,
            d.style.display = "block",
            setTimeout( () => d.style.opacity = "1", 100),
            d.closeSelf(a?.showTime || 5E3);
        else {
            var l = d.getElementsByClassName("message-button-wrap")[0];
            c = l.children[0];
            l = l.children[1];
            c.onclick = () => {
                a?.callback && a.callback(d)
            }
            ;
            l.onclick = () => {
                a?.cancelback && a?.cancelback(d);
                d.closeSelf()
            }
            ;
            c.innerText = a?.button && a.button[0] || _$$module$popup_original("btnConfirm");
            l.innerText = a?.button && a.button[1] || _$$module$popup_original("btnCancel");
            d.getElementsByClassName("message-content")[0].innerHTML = b;
            d.style.display = "block";
            setTimeout( () => d.style.opacity = "1", 100)
        }
    }
}
function closeSoftMessages$$module$popup_original() {
    let a = document.getElementsByClassName("soft");
    for (let b = 0; b < a.length; b++)
        a[b].remove()
}
function closeHardMessages$$module$popup_original() {
    let a = document.getElementsByClassName("hard");
    for (let b = 0; b < a.length; b++)
        a[b].remove()
}
function httpErrorHandlerWithRetry$$module$popup_original(a, b, c) {
    recoverChanges$$module$popup_original();
    track$$module$popup_original.error("HTTPError", a);
    return 401 === a.status ? logout$$module$popup_original(401, !0) : 403 === a.status ? fetchWithRefreshToken$$module$popup_original(b, c) : 404 === a.status ? showMessage$$module$popup_original(_$$module$popup_original("tipFetch404")) : 500 === a.status ? showMessage$$module$popup_original("Server Error") : showMessage$$module$popup_original(`HTTPError[${a.status}]`)
}
function httpErrorHandler$$module$popup_original(a) {
    recoverChanges$$module$popup_original();
    track$$module$popup_original.error("HTTPError", a);
    return 401 === a.status ? logout$$module$popup_original(401, !0) : 403 === a.status ? logout$$module$popup_original(403, !0) : 404 === a.status ? showMessage$$module$popup_original(_$$module$popup_original("tipFetch404")) : 500 === a.status ? showMessage$$module$popup_original("Server Error") : showMessage$$module$popup_original(`HTTPError[${a.status}]`)
}
function jsonErrorHandler$$module$popup_original(a) {
    recoverChanges$$module$popup_original();
    track$$module$popup_original.warn("jsonError", a);
    if (-102 !== a.code)
        return -105 === a.code ? showMessage$$module$popup_original(_$$module$popup_original("errJson105")) : -107 === a.code ? showMessage$$module$popup_original(_$$module$popup_original("errJson107")) : -108 === a.code ? showMessage$$module$popup_original(_$$module$popup_original("errJson108")) : -202 === a.code ? a : -203 === a.code ? showMessage$$module$popup_original(_$$module$popup_original("errJson203")) : -301 === a.code ? showMessage$$module$popup_original(_$$module$popup_original("errJson301")) : -302 === a.code ? showMessage$$module$popup_original(_$$module$popup_original("errJson302")) : -303 === a.code ? showMessage$$module$popup_original(_$$module$popup_original("errJson303")) : showMessage$$module$popup_original(`${a?.msg}<br/>[code: ${a.code}]`)
}
function fetchErrorHandler$$module$popup_original(a) {
    recoverChanges$$module$popup_original();
    track$$module$popup_original.error("fetchError", a);
    return showMessage$$module$popup_original("fetchError<br/>" + a)
}
async function fetchHandler$$module$popup_original(a, b, c) {
    if (!a.ok)
        return httpErrorHandlerWithRetry$$module$popup_original(a, b, c);
    a = await a.json();
    return -100 >= a.code ? jsonErrorHandler$$module$popup_original(a) : a
}
async function fetchWithRefreshToken$$module$popup_original(a, b) {
    const c = await getRefreshToken$$module$popup_original();
    return fetch(backendExtUrl$$module$popup_original.RefreshToken, {
        method: "put",
        headers: {
            EXTAuthorization: `Bearer ${c}`
        }
    }).then(async d => {
        if (!d.ok)
            return httpErrorHandler$$module$popup_original(d);
        d = await d.json();
        await browser$$module$popup_original.setStorageItem({
            loginToken: d.data.token
        }, null, cache$$module$popup_original);
        return a(...b)
    }
    ).catch(d => fetchErrorHandler$$module$popup_original(d))
}
function fetchPost$$module$popup_original(a, b) {
    return fetch(a, {
        method: "post",
        mode: 'cors',
        credentials: 'include',
        body: JSON.stringify(b),
        headers: {
            "Content-Type": "application/json"
        }
    }).then(c => fetchHandler$$module$popup_original(c, fetchPost$$module$popup_original, [a, b])).catch(c => fetchErrorHandler$$module$popup_original(c))
}
async function fetchPostWithToken$$module$popup_original(a, b) {
    const c = await getLoginToken$$module$popup_original();
    return fetch(a, {
        method: "post",
        body: JSON.stringify(b),
        headers: {
            "Content-Type": "application/json",
            EXTAuthorization: `Bearer ${c}`
        }
    }).then(d => fetchHandler$$module$popup_original(d, fetchPostWithToken$$module$popup_original, [a, b])).catch(d => fetchErrorHandler$$module$popup_original(d))
}
function fetchPostWWW$$module$popup_original(a, b) {
    const c = new FormData;
    for (let d in b)
        c.set(d, b[d]);
    return fetch(a, {
        method: "post",
        body: c
    }).then(d => fetchHandler$$module$popup_original(d, fetchPostWWW$$module$popup_original, [a, b])).catch(d => fetchErrorHandler$$module$popup_original(d))
}
function fetchGet$$module$popup_original(a, b) {
    b && Object.keys(b).length && (a += formatQueryString$$module$popup_original(a, b));
    return fetch(a, {
        method: "get"
    }).then(c => fetchHandler$$module$popup_original(c, fetchGet$$module$popup_original, [a])).catch(c => fetchErrorHandler$$module$popup_original(c))
}
async function fetchGetWithToken$$module$popup_original(a, b) {
    b && Object.keys(b).length && (a += formatQueryString$$module$popup_original(a, b));
    b = await getLoginToken$$module$popup_original();
    return fetch(a, {
        method: "get",
        headers: {
            EXTAuthorization: `Bearer ${b}`
        }
    }).then(c => fetchHandler$$module$popup_original(c, fetchGetWithToken$$module$popup_original, [a])).catch(c => fetchErrorHandler$$module$popup_original(c))
}
function formatQueryString$$module$popup_original(a, b) {
    let c = "?";
    0 <= a.indexOf("?") && (c = "&");
    for (let d in b)
        c += `${d}=${b[d]}&`;
    return c.slice(0, -1)
}
async function openUrl$$module$popup_original(a, b, c, d) {
    if (a) {
        var k = b || {};
        if (LOGIN_SHARE$$module$popup_original && c) {
            if (!d && (showMessage$$module$popup_original(_$$module$popup_original("tipJumping")),
            c = await fetchGetWithToken$$module$popup_original(backendExtUrl$$module$popup_original.ShareLogin)) && (0 === c.code && (d = c.data.share_token),
            -2 === c.code))
                return d = c.data.share_token,
                k = c.data.other_user ? c.data.other_user + "<br/>" : "",
                closeSoftMessages$$module$popup_original(),
                showMessage$$module$popup_original({
                    type: "hard",
                    status: _$$module$popup_original("tipShareLoginPrefix") + k + _$$module$popup_original("tipShareLoginSuffix"),
                    callback: l => {
                        openUrl$$module$popup_original(a, b, !0, d);
                        l.closeSelf()
                    }
                    ,
                    cancelback: l => {
                        openUrl$$module$popup_original(a, b, !1)
                    }
                });
            d && (k.ext_share = d)
        }
        Object.keys(k).length && (a += formatQueryString$$module$popup_original(a, k));
        window.open(a)
    }
}
async function clickJump$$module$popup_original(a, b, c, d) {
    if (c) {
        var k = [];
        Array.isArray(a) ? a.forEach(l => k = [...k, ...l.getElementsByClassName(b)]) : k = [...a.getElementsByClassName(b)];
        k.forEach(l => l.onclick = () => openUrl$$module$popup_original(c, null, d))
    }
}
function waveEffect$$module$popup_original(a, b) {
    a.classList.contains("on") || a.classList.add("on");
    setTimeout( () => a.style.opacity = "0.15", 100);
    return setInterval( () => a.style.opacity = "1" === a.style.opacity ? "0.15" : "1", b)
}
function recoverChanges$$module$popup_original() {
    clearInterval(confirmWxLoginTimer$$module$popup_original);
    clearTimeout(closeWxLoginTimer$$module$popup_original);
    nodeLoginButton$$module$popup_original.value = _$$module$popup_original("btnLogin");
    nodeLogoutButton$$module$popup_original.firstElementChild.innerText = _$$module$popup_original("btnLogout");
    nodeAutoLoginButton$$module$popup_original.firstElementChild.innerText = _$$module$popup_original("btnAutoLogin");
    nodeSubmitBugButton$$module$popup_original.value = _$$module$popup_original("btnSubmit")
}
async function detectAutoLogin$$module$popup_original() {
    await browser$$module$popup_original.setStorageItem("otherLoginMethodClicked", "0", cache$$module$popup_original);
    const a = await background$$module$popup_original({
        back: "getKdlCookies"
    });
    a && fetchPost$$module$popup_original(backendExtUrl$$module$popup_original.AutoLogin, {
        login_method: "cookie",
        cookie_web: a.data,
        cookie_login: 0
    }).then(async b => {
        b && 0 === b.code && await showPage$$module$popup_original("page-auto-login")
    }
    )
}
function addAutoLoginListener$$module$popup_original() {
    nodeAutoLoginButton$$module$popup_original.onclick = async () => {
        nodeAutoLoginButton$$module$popup_original.firstElementChild.innerText = _$$module$popup_original("btnLogining");
        const a = await background$$module$popup_original({
            back: "getKdlCookies"
        });
        if (!a)
            return showMessage$$module$popup_original(_$$module$popup_original("tipKdlCookiesNotExist"));
        fetchPost$$module$popup_original(backendExtUrl$$module$popup_original.Login, {
            login_method: "cookie",
            cookie_web: a.data,
            cookie_login: 1,
            wx_nickname: cache$$module$popup_original.wx_nickname,
            wx_mp_openid: cache$$module$popup_original.wx_mp_openid,
            wx_unionid: cache$$module$popup_original.wx_unionid
        }).then(async b => {
            if (b)
                return 0 === b.code ? saveLoginConfig$$module$popup_original(b.data) : -202 === b.code ? (await browser$$module$popup_original.setStorageItem("otherLoginMethodClicked", "1", cache$$module$popup_original).then( () => showPage$$module$popup_original("page-login")),
                showMessage$$module$popup_original(_$$module$popup_original("errJson202"))) : showMessage$$module$popup_original(`${b.msg}<br/>[code: ${b.code}]`)
        }
        )
    }
    ;
    nodeAutoOtherLoginMethod$$module$popup_original.onclick = () => browser$$module$popup_original.setStorageItem("otherLoginMethodClicked", "1", cache$$module$popup_original).then( () => showPage$$module$popup_original("page-login"))
}
function initMobileSelect$$module$popup_original() {
    const a = document.getElementsByClassName("select")[0]
      , b = a.getElementsByClassName("select-c")[0]
      , c = b.getElementsByTagName("li");
    a.onclick = d => {
        d.stopPropagation();
        d.preventDefault();
        a.classList.toggle("select-focus");
        document.body.onclick = () => a.classList.remove("select-focus")
    }
    ;
    b.onclick = d => {
        if (Array.from(c).includes(d.target)) {
            for (var k = 0; k < c.length; k++)
                c[k].classList.remove("active");
            d.target.classList.add("active");
            k = d.target.closest(".select-c").getElementsByClassName("select-value")[0];
            k.innerText = "+" + d.target.dataset.dialValue;
            k.setAttribute("data-country-code", d.target.dataset.iso2Value)
        }
    }
}
async function initWxqrcode$$module$popup_original() {
    var a = document.getElementById("qrcode_expire_box");
    a && a.remove();
    if (!(cache$$module$popup_original.wxLoginPeriod && 12E4 > +new Date - cache$$module$popup_original.wxLoginPeriod)) {
        a = await fetchPost$$module$popup_original(backendExtUrl$$module$popup_original.Login, {
            login_method: "wx_qrcode",
            wx_login: 0
        });
        if (!a)
            return;
        if (!a.data.wx_qrcode || !a.data.scene_id)
            return showMessage$$module$popup_original(_$$module$popup_original("errWxLoginError"));
        await browser$$module$popup_original.setStorageItem({
            wxLoginPeriod: +new Date,
            wxLoginQrcode: a.data.wx_qrcode,
            wxLoginSceneId: a.data.scene_id
        }, null, cache$$module$popup_original)
    }
    nodeImgWxQrcode$$module$popup_original.src = cache$$module$popup_original.wxLoginQrcode;
    nodeImgWxQrcode$$module$popup_original.style.opacity = "1";
    confirmWxLogin$$module$popup_original();
    nodeLoginMethodWxQrcode$$module$popup_original.onclick = b => {
        let c = document.getElementById("qrcode_expire_box");
        c && b.target === c && (c.remove(),
        confirmWxLogin$$module$popup_original())
    }
}
function initLoginMethod$$module$popup_original() {
    clearInterval(confirmWxLoginTimer$$module$popup_original);
    clearTimeout(closeWxLoginTimer$$module$popup_original);
    nodeLoginMethodWxQrcode$$module$popup_original.style.display = "none";
    nodeLoginMethodMobile$$module$popup_original.style.display = "none";
    cache$$module$popup_original.loginMethod === loginMethodWxQrcodeId$$module$popup_original && (nodeLoginMethodWxQrcode$$module$popup_original.style.display = "block",
    nodeLoginMethodInfo$$module$popup_original.innerText = _$$module$popup_original("tipLoginMethodWxqrcode"),
    nodeOtherLoginMethodInfo$$module$popup_original.innerHTML = _$$module$popup_original("tipLoginMethodMobile"),
    initWxqrcode$$module$popup_original());
    cache$$module$popup_original.loginMethod === loginMethodMobileId$$module$popup_original && (nodeLoginMethodMobile$$module$popup_original.style.display = "block",
    nodeLoginMethodInfo$$module$popup_original.innerText = _$$module$popup_original("tipLoginMethodMobile"),
    nodeOtherLoginMethodInfo$$module$popup_original.innerHTML = '<i class="icon icon-wx"></i>&nbsp;&nbsp;' + _$$module$popup_original("tipLoginMethodWxqrcode"),
    nodeTelCDate$$module$popup_original.innerHTML = genTelLi$$module$popup_original(),
    initMobileSelect$$module$popup_original());
    nodeOtherLoginMethod$$module$popup_original.onclick = () => {
        browser$$module$popup_original.setStorageItem("loginMethod", cache$$module$popup_original.loginMethod === loginMethodWxQrcodeId$$module$popup_original ? loginMethodMobileId$$module$popup_original : loginMethodWxQrcodeId$$module$popup_original, cache$$module$popup_original).then(initLoginMethod$$module$popup_original)
    }
}
let confirmWxLoginTimer$$module$popup_original, closeWxLoginTimer$$module$popup_original;
function confirmWxLogin$$module$popup_original() {
    clearInterval(confirmWxLoginTimer$$module$popup_original);
    clearTimeout(closeWxLoginTimer$$module$popup_original);
    confirmWxLoginTimer$$module$popup_original = setInterval( () => {
        cache$$module$popup_original.wxLoginSceneId && fetchPost$$module$popup_original(backendExtUrl$$module$popup_original.Login, {
            login_method: "wx_qrcode",
            wx_login: 1,
            scene_id: cache$$module$popup_original.wxLoginSceneId
        }).then(async a => {
            if (a) {
                if (0 === a.code)
                    return showMessage$$module$popup_original(_$$module$popup_original("btnLogining")),
                    saveLoginConfig$$module$popup_original(a.data);
                if (-21 !== a.code) {
                    clearInterval(confirmWxLoginTimer$$module$popup_original);
                    clearTimeout(closeWxLoginTimer$$module$popup_original);
                    var b = ""
                      , c = ""
                      , d = "";
                    -99 === a.code && (b = a.data.wx_nickname,
                    c = a.data.wx_mp_openid,
                    d = a.data.wx_unionid,
                    showMessage$$module$popup_original(_$$module$popup_original("errWxLoginUnbind")));
                    browser$$module$popup_original.setStorageItem({
                        loginMethod: loginMethodMobileId$$module$popup_original,
                        otherLoginMethodClicked: "1",
                        wx_nickname: b,
                        wx_mp_openid: c,
                        wx_unionid: d
                    }, null, cache$$module$popup_original).then(async () => {
                        await showPage$$module$popup_original("page-login")
                    }
                    );
                    -99 !== a.code && showMessage$$module$popup_original(`${a.msg}<br/>[code: ${a.code}]`)
                }
            }
        }
        )
    }
    , 2E3);
    closeWxLoginTimer$$module$popup_original = setTimeout( () => {
        clearInterval(confirmWxLoginTimer$$module$popup_original);
        qrcodeExpireOn$$module$popup_original("." + loginMethodWxQrcodeId$$module$popup_original, "qrcode_expire_box_login")
    }
    , DEBUG_DEV$$module$popup_original && 2E4 || 12E4)
}
function qrcodeExpireOn$$module$popup_original(a, b) {
    b = b || "";
    var c = document.getElementById("qrcode_expire_box");
    c && c.remove();
    a = document.querySelector(a);
    c = document.createElement("div");
    const d = _$$module$popup_original("tipWxqrcodeExpired")
      , k = _$$module$popup_original("tipRefreshWxqrcode");
    a.append(c);
    c.outerHTML = `
        <div id="qrcode_expire_box" class="${b}" style="width:${a.clientWidth}px;height:${a.clientHeight}px;">
            <div class="qrcode_expire_box__content">
                <i class="icon icon-zhongzhi1" style="display:none;"></i>
                <p>${d} <a href="#">${k}</a></p>
            </div>
        </div>`
}
function initCurrentProxyPanel$$module$popup_original() {
    if ("switch-order" === cache$$module$popup_original.switchType) {
        let a = "";
        (new RegExp("^\\d" + _$$module$popup_original("regOrderExpire") + "$")).test(cache$$module$popup_original.proxyExpireStatus) ? a = classNameAboutExpire$$module$popup_original : cache$$module$popup_original.proxyExpireStatus === _$$module$popup_original("regOrderExpireOneday") && (a = classNameOnedayExpire$$module$popup_original);
        cache$$module$popup_original.proxyInfoShow ? (nodeProxyShow$$module$popup_original.innerHTML = `${cache$$module$popup_original.proxyInfoShow}<span class="${a}">${cache$$module$popup_original.proxyExpireStatus}</span>`,
        nodeProxySpec$$module$popup_original.innerText = cache$$module$popup_original.proxyInfoSpec) : (nodeProxyShow$$module$popup_original.innerHTML = _$$module$popup_original("tipSelectOrder"),
        nodeProxySpec$$module$popup_original.innerText = "");
        "tps_pro" === cache$$module$popup_original.proxyType ? nodeCurrentProxyImg$$module$popup_original.src = imgProxyTpsPro$$module$popup_original : "tps" === cache$$module$popup_original.proxyType ? nodeCurrentProxyImg$$module$popup_original.src = imgProxyTps$$module$popup_original : "lrps" === cache$$module$popup_original.proxyType ? nodeCurrentProxyImg$$module$popup_original.src = imgProxyLrps$$module$popup_original : "kps" === cache$$module$popup_original.proxyType ? nodeCurrentProxyImg$$module$popup_original.src = imgProxyKps$$module$popup_original : "fps" === cache$$module$popup_original.proxyType ? nodeCurrentProxyImg$$module$popup_original.src = imgProxyFps$$module$popup_original : "sfps" === cache$$module$popup_original.proxyType && (nodeCurrentProxyImg$$module$popup_original.src = imgProxySfps$$module$popup_original);
        nodeCurrentProxyPanel$$module$popup_original.onclick = () => showPage$$module$popup_original("page-list")
    }
    "switch-app" === cache$$module$popup_original.switchType && (cache$$module$popup_original.proxyInfoShow ? (nodeProxyShow$$module$popup_original.innerHTML = _$$module$popup_original("initSwitchApp") + "&nbsp;&nbsp;" + cache$$module$popup_original.proxyInfoShow.split("#").slice(1).join("#"),
    nodeProxySpec$$module$popup_original.innerText = cache$$module$popup_original.proxyInfoSpec) : (nodeProxyShow$$module$popup_original.innerHTML = _$$module$popup_original("tipSelectOrder"),
    nodeProxySpec$$module$popup_original.innerText = ""),
    nodeCurrentProxyImg$$module$popup_original.src = imgProxyAps$$module$popup_original,
    nodeCurrentProxyPanel$$module$popup_original.onclick = () => showPage$$module$popup_original("page-list"))
}
function initIpInfoPanel$$module$popup_original() {
    function a() {
        nodeToggleIpShow$$module$popup_original.classList.remove("local");
        nodeToggleIpShow$$module$popup_original.classList.remove("proxy");
        nodeToggleIpShow$$module$popup_original.classList.add("proxy");
        nodeIpShow$$module$popup_original.innerText = cache$$module$popup_original.localIp;
        nodeIpLocation$$module$popup_original.innerText = cache$$module$popup_original.localLocation;
        nodeIpProvider$$module$popup_original.innerText = cache$$module$popup_original.localProvider;
        nodeToggleIpShow$$module$popup_original.innerText = _$$module$popup_original("tipLocalIp")
    }
    function b() {
        nodeToggleIpShow$$module$popup_original.classList.remove("local");
        nodeToggleIpShow$$module$popup_original.classList.remove("proxy");
        nodeToggleIpShow$$module$popup_original.classList.add("local");
        nodeIpShow$$module$popup_original.innerText = cache$$module$popup_original.proxyIp;
        nodeIpLocation$$module$popup_original.innerText = cache$$module$popup_original.proxyLocation;
        nodeIpProvider$$module$popup_original.innerText = cache$$module$popup_original.proxyProvider;
        nodeToggleIpShow$$module$popup_original.innerText = _$$module$popup_original("tipProxyIp")
    }
    ~~cache$$module$popup_original.connectStatus ? b() : a();
    nodeToggleIpButton$$module$popup_original.onclick = () => {
        nodeToggleIpShow$$module$popup_original.innerText === _$$module$popup_original("tipProxyIp") ? a() : b()
    }
    ;
    let c = !1;
    nodeRefreshIpButton$$module$popup_original.onclick = async () => {
        if (c)
            return showMessage$$module$popup_original(_$$module$popup_original("tipIpInfoTooFrequency"));
        c = !0;
        setTimeout( () => c = !1, 1E4);
        if (nodeToggleIpShow$$module$popup_original.innerText === _$$module$popup_original("tipProxyIp") && !~~cache$$module$popup_original.connectStatus)
            return c = !1,
            showMessage$$module$popup_original(_$$module$popup_original("actionTitleUnconnected"));
        await refreshIpInfo$$module$popup_original(!1)
    }
}
function initAppInfoPanel$$module$popup_original() {
    nodeAppShowInfo$$module$popup_original.innerText = _$$module$popup_original("tipCurrentApsNode") + ": ";
    nodeAppShow$$module$popup_original.innerText = cache$$module$popup_original.proxyInfoShow;
    nodeAppInfoPanel$$module$popup_original.dataset.delayLevel = cache$$module$popup_original.proxyDelayLevel;
    nodeAppInfoPanelIconDelay$$module$popup_original.dataset.delayLevel = cache$$module$popup_original.proxyDelayLevel;
    nodeAppInfoPanelDelay$$module$popup_original.innerText = "0" !== cache$$module$popup_original.proxyDelayLevel ? cache$$module$popup_original.proxyDelay + "ms" : _$$module$popup_original("tipOverload")
}
async function refreshIpInfo$$module$popup_original(a, b) {
    let c, d;
    nodeToggleIpShow$$module$popup_original.innerText === _$$module$popup_original("tipLocalIp") ? (c = "localIp",
    d = await fetchGetWithToken$$module$popup_original(backendExtUrl$$module$popup_original.GetIpInfo, {
        local_ip: cache$$module$popup_original.localIp
    })) : (c = "proxyIp",
    d = await fetchGetWithToken$$module$popup_original(backendExtUrl$$module$popup_original.GetIpInfo, {
        secret_id: cache$$module$popup_original.proxySecretId,
        id_for_user: "kps" === cache$$module$popup_original.proxyType ? cache$$module$popup_original.proxyKpsIdForUser : "lrps" === cache$$module$popup_original.proxyType ? cache$$module$popup_original.proxyLrpsIdForUser : cache$$module$popup_original.proxySfpsIdForUser
    }));
    if (d) {
        if (0 !== d.code)
            return a ? nodeIpShow$$module$popup_original.innerText = b : -2 === d.code ? showMessage$$module$popup_original(_$$module$popup_original("errIpInfoTooFrequency")) : showMessage$$module$popup_original(`${d.msg}<br/>[code: ${d.code}]`);
        b = {
            lastRefreshIpInfoTime: +new Date
        };
        "localIp" === c ? Object.assign(b, {
            localIp: d.data.ip,
            localProvider: d.data.provider,
            localLocation: d.data.location
        }) : Object.assign(b, {
            proxyIp: d.data.ip,
            proxyProvider: d.data.provider,
            proxyLocation: d.data.location
        });
        await browser$$module$popup_original.setStorageItem(b, null, cache$$module$popup_original);
        nodeIpShow$$module$popup_original.innerText = d.data.ip;
        nodeIpLocation$$module$popup_original.innerText = d.data.location;
        nodeIpProvider$$module$popup_original.innerText = d.data.provider;
        a || showMessage$$module$popup_original(_$$module$popup_original("tipRefreshSuccess"))
    }
}
async function autoRefreshIpInfo$$module$popup_original() {
    if (~~cache$$module$popup_original.connectStatus && "page-connect" === cache$$module$popup_original.currentPageId && nodeToggleIpShow$$module$popup_original.innerText === _$$module$popup_original("tipProxyIp") && "0" !== cache$$module$popup_original.lastRefreshIpInfoTime && !(1E4 > +new Date - cache$$module$popup_original.lastRefreshIpInfoTime)) {
        var a = nodeIpShow$$module$popup_original.innerText;
        nodeIpShow$$module$popup_original.innerText = _$$module$popup_original("tipIpInfoDetecting");
        await refreshIpInfo$$module$popup_original(!0, a)
    }
}
function initHeadPic$$module$popup_original(a) {
    if ("page-option" === a && cache$$module$popup_original.username) {
        for (a = 0; a < nodeHeadPics$$module$popup_original.length; a++)
            nodeHeadPics$$module$popup_original[a].innerText = cache$$module$popup_original.username[0].toUpperCase();
        a = nodeOptionUserInfo$$module$popup_original.getElementsByTagName("p")[0];
        var b = nodeOptionUserInfo$$module$popup_original.getElementsByTagName("span")[0];
        a.innerText = cache$$module$popup_original.username;
        b.classList.remove("verified");
        b.classList.remove("unverified");
        ~~cache$$module$popup_original.identityVerified ? (b.innerText = _$$module$popup_original("tipUserIdentified"),
        b.classList.add("verified")) : (b.innerText = _$$module$popup_original("tipUserUnidentified"),
        b.classList.add("unverified"));
        ~~cache$$module$popup_original.subAccountRole && (b.innerText = _$$module$popup_original("tipUserIsSubAccount"))
    }
}
let refreshAppConnectionsTimer$$module$popup_original;
async function refreshAppConnections$$module$popup_original() {
    async function a() {
        const b = nodeHeaderRight$$module$popup_original.getElementsByClassName("app-online")[0];
        if (b) {
            var c = b.getElementsByTagName("span")
              , d = c[1];
            c = c[0];
            var {max_conns: k=0, curr_conns: l=0} = await getApsConns$$module$popup_original() || {};
            d.innerText = "/" + String(k);
            c.innerText = String(l);
            b.style.display = "inline-block"
        }
    }
    "switch-app" === cache$$module$popup_original.switchType && (clearTimeout(refreshAppConnectionsTimer$$module$popup_original),
    await a(),
    refreshAppConnectionsTimer$$module$popup_original = setTimeout(a, DEBUG_DEV$$module$popup_original ? 1E4 : 6E4))
}
function initHead$$module$popup_original(a) {
    switch (a) {
    case "page-connect":
        nodeHeaderLeft$$module$popup_original.innerHTML = '<i class="icon icon-options"></i>';
        nodeHeaderRight$$module$popup_original.innerHTML = '<div class="app-online"><i class="icon icon-app-online"></i><p><span></span><span></span></p></div><i class="icon icon-buy"></i>';
        nodeHeaderLeft$$module$popup_original.getElementsByClassName("icon-options")[0].onclick = () => showPage$$module$popup_original("page-option");
        refreshAppConnections$$module$popup_original();
        break;
    default:
        nodeHeaderLeft$$module$popup_original.innerHTML = "";
        nodeHeaderRight$$module$popup_original.innerHTML = "";
        nodeHeaderLeft$$module$popup_original.append(nodeTemplateBack$$module$popup_original.cloneNode(!0));
        const b = nodeHeaderLeft$$module$popup_original.getElementsByClassName("svg-back")[0];
        let c;
        c = "page-bug-report" === a ? "page-option" : "page-connect";
        b.onclick = () => showPage$$module$popup_original(c)
    }
    switch (a) {
    case "page-list":
        nodeHeaderMiddle$$module$popup_original.innerHTML = "<p>" + _$$module$popup_original("tipSelectOrder") + "</p>";
        nodeHeaderRight$$module$popup_original.innerHTML = '<i class="icon icon-refresh"></i>';
        nodeHeaderRight$$module$popup_original.getElementsByClassName("icon-refresh")[0].onclick = async () => {
            "switch-app" === cache$$module$popup_original.switchType && (cache$$module$popup_original.cachedApsList = "{}");
            await showPage$$module$popup_original("page-list");
            showMessage$$module$popup_original({
                showTime: 2E3,
                status: _$$module$popup_original("tipRefreshSuccess")
            })
        }
        ;
        break;
    case "page-bug-report":
        nodeHeaderMiddle$$module$popup_original.innerHTML = "<p>" + _$$module$popup_original("tipBugReport") + "</p>";
        break;
    default:
        nodeHeaderLogin$$module$popup_original.innerHTML = "",
        nodeHeaderMiddle$$module$popup_original.innerHTML = "",
        nodeHeaderLogin$$module$popup_original.append(nodeTemplateLogo$$module$popup_original.cloneNode(!0)),
        nodeHeaderMiddle$$module$popup_original.append(nodeTemplateLogo$$module$popup_original.cloneNode(!0))
    }
}
let timerWaveStar$$module$popup_original, timerGetUsedTimer$$module$popup_original;
async function initConnectButton$$module$popup_original(a) {
    function b() {
        connectButtonList$$module$popup_original.forEach(g => {
            g.classList.remove("in");
            g.classList.remove("on");
            g.classList.remove("off")
        }
        )
    }
    async function c() {
        b();
        connectButtonList$$module$popup_original.forEach(g => g.classList.add("off"));
        nodeConnectStatus$$module$popup_original.innerText = "OFF";
        nodeConnectInfo$$module$popup_original.innerText = _$$module$popup_original("tipProxyUnused");
        nodeConnectStar$$module$popup_original.style.opacity = "1"
    }
    async function d() {
        b();
        connectButtonList$$module$popup_original.forEach(g => g.classList.add("on"));
        nodeConnectStatus$$module$popup_original.innerText = "ON";
        l();
        clearInterval(timerWaveStar$$module$popup_original);
        timerWaveStar$$module$popup_original = waveEffect$$module$popup_original(nodeConnectStar$$module$popup_original, 2E3)
    }
    async function k() {
        b();
        connectButtonList$$module$popup_original.forEach(g => g.classList.add("on"));
        connectButtonList$$module$popup_original.forEach(g => g.classList.add("in"));
        nodeConnectStatus$$module$popup_original.innerText = "···";
        nodeConnectInfo$$module$popup_original.innerText = _$$module$popup_original("actionTitleConnecting");
        clearInterval(timerWaveStar$$module$popup_original);
        timerWaveStar$$module$popup_original = waveEffect$$module$popup_original(nodeConnectStar$$module$popup_original, 2E3);
        await browser$$module$popup_original.setStorageItem({
            connectStatus: ConnectStatus$$module$popup_original.connecting,
            proxyIp: _$$module$popup_original("tipIpInfoDetecting"),
            proxyLocation: _$$module$popup_original("tipIpInfoDetecting"),
            proxyProvider: ""
        }, null, cache$$module$popup_original);
        "switch-order" === cache$$module$popup_original.switchType && initIpInfoPanel$$module$popup_original()
    }
    function l() {
        function g(f) {
            f = parseInt(f);
            let e = f + " " + _$$module$popup_original("tipProxyUsedSuffixMinute");
            60 <= f && (e = parseInt(f / 60) + " " + _$$module$popup_original("tipProxyUsedSuffixHour") + " " + f % 60 + " " + _$$module$popup_original("tipProxyUsedSuffixMinute"));
            nodeConnectInfo$$module$popup_original.innerText = _$$module$popup_original("tipProxyUsedPrefix") + " " + e
        }
        clearInterval(timerGetUsedTimer$$module$popup_original);
        g(cache$$module$popup_original.proxyUsedTime);
        timerGetUsedTimer$$module$popup_original = setInterval(async () => {
            const f = await browser$$module$popup_original.getStorageItem("proxyUsedTime", "0");
            g(f)
        }
        , DEBUG_DEV$$module$popup_original ? 2E3 : 1E4)
    }
    async function m() {
        if (!cache$$module$popup_original.proxySecretId && !cache$$module$popup_original.proxyApsCode)
            return showMessage$$module$popup_original(_$$module$popup_original("tipPleaseSelectOrder"));
        await browser$$module$popup_original.setStorageItem("manualAbort", "0", cache$$module$popup_original);
        await k();
        var g = await background$$module$popup_original({
            back: "openConnect"
        });
        g ? 0 === g.code ? (await d(),
        refreshAppConnections$$module$popup_original()) : (await c(),
        -3 === g.code ? ("switch-order" === cache$$module$popup_original.switchType && showMessage$$module$popup_original(_$$module$popup_original("errProxyOrderNotExist")),
        "switch-app" === cache$$module$popup_original.switchType && showMessage$$module$popup_original(_$$module$popup_original("errAppOrderNotExist"))) : -4 === g.code ? (nodeConnectInfo$$module$popup_original.innerHTML = _$$module$popup_original("errOrderAuthType"),
        g = "",
        "switch-order" === cache$$module$popup_original.switchType && (g = `${backendWebUrl$$module$popup_original.ControlCenter}${cache$$module$popup_original.proxyType}/?orderid=${cache$$module$popup_original.proxyOrderId}`),
        "switch-app" === cache$$module$popup_original.switchType && (g = `${backendWebUrl$$module$popup_original.ControlCenter}${cache$$module$popup_original.proxyType}/`),
        await clickJump$$module$popup_original(nodePageConnect$$module$popup_original, "change-auth-type", g, !0)) : -99 === g.code ? (nodeConnectInfo$$module$popup_original.innerHTML = _$$module$popup_original("errUnsupportedOrderAuthType"),
        g = "",
        "switch-order" === cache$$module$popup_original.switchType && (g = `${backendWebUrl$$module$popup_original.ControlCenter}${cache$$module$popup_original.proxyType}/?orderid=${cache$$module$popup_original.proxyOrderId}`),
        "switch-app" === cache$$module$popup_original.switchType && (g = `${backendWebUrl$$module$popup_original.ControlCenter}${cache$$module$popup_original.proxyType}/`),
        await clickJump$$module$popup_original(nodePageConnect$$module$popup_original, "change-auth-type", g, !0)) : -10 === g.code ? showMessage$$module$popup_original(_$$module$popup_original("errShouldReagreeContract")) : -11 === g.code ? showMessage$$module$popup_original(_$$module$popup_original("errUserUnidentifiedInfo")) : -12 === g.code ? showMessage$$module$popup_original(_$$module$popup_original("errNeedRerealnameToUse")) : -20 === g.code ? (nodeConnectInfo$$module$popup_original.innerHTML = _$$module$popup_original("errFpsChangePeriodIsZero"),
        await clickJump$$module$popup_original(nodePageConnect$$module$popup_original, "change-auth-type", `${backendWebUrl$$module$popup_original.ControlCenter}${cache$$module$popup_original.proxyType}/?orderid=${cache$$module$popup_original.proxyOrderId}`, !0)) : -21 === g.code ? showMessage$$module$popup_original(_$$module$popup_original("errFpsForeignIpRequired")) : -31 === g.code ? showMessage$$module$popup_original(_$$module$popup_original("errFpsForeignIpRequired")) : -40 === g.code ? "tps_pro" === cache$$module$popup_original.proxyType ? (nodeConnectInfo$$module$popup_original.innerHTML = _$$module$popup_original("errTpsProChangePeriodIsZero"),
        await clickJump$$module$popup_original(nodePageConnect$$module$popup_original, "change-auth-type", `${backendWebUrl$$module$popup_original.ControlCenter}${cache$$module$popup_original.proxyType}/?orderid=${cache$$module$popup_original.proxyOrderId}`, !0)) : showMessage$$module$popup_original(_$$module$popup_original("errTpsChangePeriodIsZero")) : showMessage$$module$popup_original(`${g.msg}<br/>[code: ${g.code}]`)) : await c()
    }
    function n() {
        "switch-app" === cache$$module$popup_original.switchType && (refreshAppConnections$$module$popup_original(),
        initCurrentProxyPanel$$module$popup_original());
        "switch-order" === cache$$module$popup_original.switchType && initIpInfoPanel$$module$popup_original()
    }
    clearInterval(timerWaveStar$$module$popup_original);
    clearInterval(timerGetUsedTimer$$module$popup_original);
    cache$$module$popup_original.connectStatus === ConnectStatus$$module$popup_original.connected ? await d() : cache$$module$popup_original.connectStatus === ConnectStatus$$module$popup_original.disconnected ? await c() : cache$$module$popup_original.connectStatus === ConnectStatus$$module$popup_original.connecting && await k();
    if (a) {
        if (!await background$$module$popup_original({
            back: "closeConnect"
        }))
            return;
        await m();
        n()
    }
    let h = !1;
    nodeConnectButton$$module$popup_original.onclick = async () => {
        h || (h = !0,
        setTimeout( () => h = !1, 2E3),
        clearInterval(timerWaveStar$$module$popup_original),
        clearInterval(timerGetUsedTimer$$module$popup_original),
        cache$$module$popup_original.connectStatus === ConnectStatus$$module$popup_original.connecting ? (await browser$$module$popup_original.setStorageItem("manualAbort", "1"),
        await background$$module$popup_original({
            back: "closeConnect",
            params: [!0]
        }),
        await c()) : cache$$module$popup_original.connectStatus === ConnectStatus$$module$popup_original.connected ? (await background$$module$popup_original({
            back: "closeConnect"
        }),
        await c()) : await m(),
        n())
    }
}
async function setCurrentProxy$$module$popup_original(a) {
    const b = {
        switchType: a.switchType,
        proxyInfoShow: a.proxyInfoShow,
        proxyInfoSpec: a.proxyInfoSpec,
        proxySecretId: a.proxySecretId,
        proxyType: a.proxyType,
        proxyExpireStatus: "",
        proxyOrderId: "",
        proxyLrpsCode: "",
        proxyKpsCode: "",
        proxySfpsCode: "",
        proxyLrpsIdForUser: "",
        proxyKpsIdForUser: "",
        proxySfpsIdForUser: "",
        proxyDelay: "",
        proxyApsCode: "",
        proxyApsHost: "",
        proxyApsPort: "",
        proxyDelayLevel: ""
    };
    if ("switch-app" === a.switchType) {
        const c = JSON.parse(cache$$module$popup_original.latestApsCode).slice(0, 4)
          , d = c.indexOf(a.proxyApsCode);
        -1 < d && c.splice(d, 1);
        c.unshift(a.proxyApsCode);
        b.latestApsCode = JSON.stringify(c.slice(0, 4));
        b.proxyDelay = a.proxyDelay;
        b.proxyApsCode = a.proxyApsCode;
        b.proxyApsHost = a.proxyApsHost;
        b.proxyApsPort = a.proxyApsPort;
        b.proxyDelayLevel = a.proxyDelayLevel
    }
    "switch-order" === a.switchType && (b.proxyExpireStatus = a.proxyExpireStatus,
    b.proxyOrderId = a.proxyOrderId,
    "lrps" === a.proxyType && (b.proxyLrpsCode = a.proxyLrpsCode,
    b.proxyLrpsIdForUser = a.proxyLrpsIdForUser),
    "kps" === a.proxyType && (b.proxyKpsCode = a.proxyKpsCode,
    b.proxyKpsIdForUser = a.proxyKpsIdForUser),
    "sfps" === a.proxyType && (b.proxySfpsCode = a.proxySfpsCode,
    b.proxySfpsIdForUser = a.proxySfpsIdForUser));
    await browser$$module$popup_original.setStorageItem(b, null, cache$$module$popup_original);
    await showPage$$module$popup_original("page-connect", {
        reConnect: !0
    })
}
async function initPageList$$module$popup_original() {
    [nodeOrderList$$module$popup_original, nodeApsList$$module$popup_original].forEach(b => b.style.display = "none");
    if ("switch-app" === cache$$module$popup_original.listSwitchType) {
        var a = await getApsList$$module$popup_original() || {};
        a.spec = a?.spec || "";
        a.latest = JSON.parse(cache$$module$popup_original.latestApsCode).slice(0, 4);
        initAps$$module$popup_original(a);
        a = nodeSwitchApp$$module$popup_original;
        nodeApsList$$module$popup_original.style.display = "block"
    }
    if ("switch-order" === cache$$module$popup_original.listSwitchType) {
        a = await getProxyList$$module$popup_original();
        if (a.tps_pro) {
            const b = [];
            a.tps_pro.forEach(c => b.push(c.orderId));
            a.tps = a.tps.filter(c => !b.includes(c.orderId))
        }
        initOrders$$module$popup_original(a);
        a = nodeSwitchOrder$$module$popup_original;
        nodeOrderList$$module$popup_original.style.display = "flex"
    }
    nodeSwitchListButton$$module$popup_original.classList.remove("left");
    nodeSwitchListButton$$module$popup_original.classList.remove("right");
    nodeSwitchListButton$$module$popup_original.classList.add(a.dataset.switchPosition);
    nodeSwitchApp$$module$popup_original.classList.remove("active");
    nodeSwitchOrder$$module$popup_original.classList.remove("active");
    a.classList.add("active");
    [nodeSwitchApp$$module$popup_original, nodeSwitchOrder$$module$popup_original].forEach(b => {
        b.onclick = async function() {
            this.id !== cache$$module$popup_original.listSwitchType && (await browser$$module$popup_original.setStorageItem("listSwitchType", this.id, cache$$module$popup_original),
            await showPage$$module$popup_original("page-list"))
        }
    }
    )
}
function initOrders$$module$popup_original(a) {
    function b(n, h) {
        const g = [];
        h.forEach(f => {
            const e = nodeTemplateOrder$$module$popup_original.cloneNode(!0);
            "tps_pro" === n && cache$$module$popup_original.proxySecretId === f.secretId ? e.classList.add(classNameCurrentOrder$$module$popup_original) : "tps" === n && cache$$module$popup_original.proxySecretId === f.secretId ? e.classList.add(classNameCurrentOrder$$module$popup_original) : "lrps" === n && cache$$module$popup_original.proxyLrpsIdForUser && cache$$module$popup_original.proxySecretId === f.secretId && cache$$module$popup_original.proxyLrpsIdForUser === f.lrpsIdForUser ? e.classList.add(classNameCurrentOrder$$module$popup_original) : "kps" === n && cache$$module$popup_original.proxyKpsIdForUser && cache$$module$popup_original.proxySecretId === f.secretId && cache$$module$popup_original.proxyKpsIdForUser === f.kpsIdForUser ? e.classList.add(classNameCurrentOrder$$module$popup_original) : "fps" === n && cache$$module$popup_original.proxySecretId === f.secretId ? e.classList.add(classNameCurrentOrder$$module$popup_original) : "sfps" === n && cache$$module$popup_original.proxySfpsIdForUser && cache$$module$popup_original.proxySecretId === f.secretId && cache$$module$popup_original.proxySfpsIdForUser === f.sfpsIdForUser && e.classList.add(classNameCurrentOrder$$module$popup_original);
            f.orderName && (f.spec += ` ${f.orderName}`);
            if (f.status) {
                var p = "";
                (new RegExp("^\\d" + _$$module$popup_original("regOrderExpire") + "$")).test(f.status) ? p = classNameAboutExpire$$module$popup_original : f.status === _$$module$popup_original("regOrderExpireOneday") ? p = classNameOnedayExpire$$module$popup_original : f.status = "";
                if (p) {
                    const q = e.getElementsByClassName("order-expire")[0];
                    q.classList.add(p);
                    q.innerText = f.status;
                    q.style.display = "block";
                    p = e.getElementsByClassName("renew-order")[0];
                    p.innerHTML = _$$module$popup_original("initRenewOrder");
                    p.style.display = "block"
                }
            }
            e.getElementsByClassName("order-spec")[0].innerText = f.spec;
            e.getElementsByClassName("order-show")[0].innerText = f.show;
            e.dataset.show = f.show;
            e.dataset.spec = f.spec;
            e.dataset.status = f.status;
            e.dataset.secretId = f.secretId;
            e.dataset.orderId = f.orderId;
            e.dataset.type = n;
            e.dataset.lrpsCode = f.lrpsCode || "";
            e.dataset.kpsCode = f.kpsCode || "";
            e.dataset.sfpsCode = f.sfpsCode || "";
            e.dataset.lrpsIdForUser = f.lrpsIdForUser || "";
            e.dataset.kpsIdForUser = f.kpsIdForUser || "";
            e.dataset.sfpsIdForUser = f.sfpsIdForUser || "";
            "lrps" === n ? e.getElementsByClassName("order-node-id")[0].firstElementChild.innerText = f.lrpsIdForUser || "" : "kps" === n ? e.getElementsByClassName("order-node-id")[0].firstElementChild.innerText = f.kpsIdForUser || "" : "sfps" === n && (e.getElementsByClassName("order-node-id")[0].firstElementChild.innerText = f.sfpsIdForUser || "");
            g.push(e)
        }
        );
        "tps_pro" === n && nodeOrderTpsProWrap$$module$popup_original.append(...g);
        "tps" === n && nodeOrderTpsWrap$$module$popup_original.append(...g);
        "lrps" === n && nodeOrderLrpsWrap$$module$popup_original.append(...g);
        "kps" === n && nodeOrderKpsWrap$$module$popup_original.append(...g);
        "fps" === n && nodeOrderFpsWrap$$module$popup_original.append(...g);
        "sfps" === n && nodeOrderSfpsWrap$$module$popup_original.append(...g);
        nodeOrderTpsProWrap$$module$popup_original.childElementCount && (nodeOrderTpsProOuterWrap$$module$popup_original.style.display = "block");
        nodeOrderTpsWrap$$module$popup_original.childElementCount && (nodeOrderTpsOuterWrap$$module$popup_original.style.display = "block");
        nodeOrderLrpsWrap$$module$popup_original.childElementCount && (nodeOrderLrpsOuterWrap$$module$popup_original.style.display = "block");
        nodeOrderKpsWrap$$module$popup_original.childElementCount && (nodeOrderKpsOuterWrap$$module$popup_original.style.display = "block");
        nodeOrderFpsWrap$$module$popup_original.childElementCount && (nodeOrderFpsOuterWrap$$module$popup_original.style.display = "block");
        nodeOrderSfpsWrap$$module$popup_original.childElementCount && (nodeOrderSfpsOuterWrap$$module$popup_original.style.display = "block")
    }
    nodeOrderTpsProOuterWrap$$module$popup_original.style.display = "none";
    nodeOrderTpsOuterWrap$$module$popup_original.style.display = "none";
    nodeOrderLrpsOuterWrap$$module$popup_original.style.display = "none";
    nodeOrderKpsOuterWrap$$module$popup_original.style.display = "none";
    nodeOrderFpsOuterWrap$$module$popup_original.style.display = "none";
    nodeOrderSfpsOuterWrap$$module$popup_original.style.display = "none";
    for (nodeOrderListNone$$module$popup_original.style.display = "none"; nodeOrderTpsProWrap$$module$popup_original.firstChild; )
        nodeOrderTpsProWrap$$module$popup_original.removeChild(nodeOrderTpsProWrap$$module$popup_original.firstChild);
    for (; nodeOrderTpsWrap$$module$popup_original.firstChild; )
        nodeOrderTpsWrap$$module$popup_original.removeChild(nodeOrderTpsWrap$$module$popup_original.firstChild);
    for (; nodeOrderLrpsWrap$$module$popup_original.firstChild; )
        nodeOrderLrpsWrap$$module$popup_original.removeChild(nodeOrderLrpsWrap$$module$popup_original.firstChild);
    for (; nodeOrderKpsWrap$$module$popup_original.firstChild; )
        nodeOrderKpsWrap$$module$popup_original.removeChild(nodeOrderKpsWrap$$module$popup_original.firstChild);
    for (; nodeOrderFpsWrap$$module$popup_original.firstChild; )
        nodeOrderFpsWrap$$module$popup_original.removeChild(nodeOrderFpsWrap$$module$popup_original.firstChild);
    for (; nodeOrderSfpsWrap$$module$popup_original.firstChild; )
        nodeOrderSfpsWrap$$module$popup_original.removeChild(nodeOrderSfpsWrap$$module$popup_original.firstChild);
    if (a) {
        var c = a.tps_pro
          , d = a.tps
          , k = a.lrps
          , l = a.kps
          , m = a.fps;
        a = a.sfps;
        c?.length && b("tps_pro", c);
        d?.length && b("tps", d);
        k?.length && b("lrps", k);
        l?.length && b("kps", l);
        m?.length && b("fps", m);
        a?.length && b("sfps", a);
        nodeOrderTpsProWrap$$module$popup_original.childElementCount || nodeOrderTpsWrap$$module$popup_original.childElementCount || nodeOrderLrpsWrap$$module$popup_original.childElementCount || nodeOrderKpsWrap$$module$popup_original.childElementCount || nodeOrderFpsWrap$$module$popup_original.childElementCount || nodeOrderSfpsWrap$$module$popup_original.childElementCount || (nodeOrderListNone$$module$popup_original.style.display = "flex",
        clickJump$$module$popup_original(nodePageList$$module$popup_original, "buy-button", backendWebUrl$$module$popup_original.Buy, !0));
        [nodeOrderTpsProWrap$$module$popup_original, nodeOrderTpsWrap$$module$popup_original, nodeOrderLrpsWrap$$module$popup_original, nodeOrderKpsWrap$$module$popup_original, nodeOrderFpsWrap$$module$popup_original, nodeOrderSfpsWrap$$module$popup_original].forEach(n => {
            n.onclick = async h => {
                const g = h.target.className;
                ["order-spec", "order-show", "renew-order"].includes(g) && (h = h.target.closest("li").dataset,
                "renew-order" === g ? await openUrl$$module$popup_original(backendWebUrl$$module$popup_original.Renew, {
                    orderid: h.orderId
                }, !0) : await setCurrentProxy$$module$popup_original({
                    switchType: "switch-order",
                    proxyExpireStatus: h.status,
                    proxyInfoShow: h.show,
                    proxyInfoSpec: h.spec,
                    proxySecretId: h.secretId,
                    proxyType: h.type,
                    proxyOrderId: h.orderId,
                    proxyLrpsCode: h.lrpsCode,
                    proxyKpsCode: h.kpsCode,
                    proxySfpsCode: h.sfpsCode,
                    proxyLrpsIdForUser: h.lrpsIdForUser,
                    proxyKpsIdForUser: h.kpsIdForUser,
                    proxySfpsIdForUser: h.sfpsIdForUser
                }))
            }
        }
        )
    }
}
function addFavorListener$$module$popup_original(a) {
    const b = document.getElementsByClassName("favor-wrap");
    for (let c of b)
        c.onclick = function(d) {
            d.stopPropagation();
            const k = this
              , l = this.firstElementChild.classList.contains("not-favor")
              , m = this.closest("li").dataset.apsCode;
            fetchPostWithToken$$module$popup_original(backendAppUrl$$module$popup_original.ApsFavor, {
                favor: ~~l,
                aps_code: m
            }).then(async n => {
                if (n) {
                    if (0 !== n.code)
                        return showMessage$$module$popup_original(`${n.msg}<br/>[code: ${n.code}]`);
                    showMessage$$module$popup_original({
                        showTime: 3E3,
                        status: l ? _$$module$popup_original("tipSetFavorSuccess") : _$$module$popup_original("tipSetNotFavorSuccess")
                    });
                    l ? (k.firstElementChild.classList.remove("not-favor"),
                    k.firstElementChild.classList.add("favor")) : (k.firstElementChild.classList.remove("favor"),
                    k.firstElementChild.classList.add("not-favor"));
                    n = JSON.parse(cache$$module$popup_original.cachedApsList);
                    Object.isEmpty(n) || (l ? n.favor.push(m) : 0 <= n.favor.indexOf(m) && n.favor.pop(n.favor.indexOf(m)));
                    await browser$$module$popup_original.setStorageItem("cachedApsList", JSON.stringify(n), cache$$module$popup_original);
                    a && showPage$$module$popup_original("page-list")
                }
            }
            )
        }
}
function getDelayLevel$$module$popup_original(a) {
    return 60 >= a ? "4" : 80 >= a ? "3" : 100 >= a ? "2" : 300 >= a ? "1" : "0"
}
function initAps$$module$popup_original(a) {
    function b(d, k, l) {
        const m = [];
        if ("all" === d) {
            var n = nodeTemplateApsRandom$$module$popup_original.cloneNode(!0);
            n.getElementsByClassName("aps-random-name")[0].innerText = _$$module$popup_original("initApsRandom");
            n.onclick = async () => {
                const g = function() {
                    var f = Object.values(l);
                    const e = [];
                    if (5 <= f.length) {
                        const p = [20, 30, 40, 60, 80, 100, 120, 140, 160, 180, 200, 300, Number.MAX_VALUE];
                        for (let q of p)
                            if (e.push(...f.filter(r => r.delay <= q)),
                            5 <= e.length)
                                break
                    } else
                        e.push(...f);
                    if (1 === e.length)
                        return e[0];
                    for (; ; )
                        if (f = e[Math.floor(Math.random() * e.length)],
                        f.code !== cache$$module$popup_original.proxyApsCode)
                            return f
                }();
                await setCurrentProxy$$module$popup_original({
                    switchType: "switch-app",
                    proxyInfoShow: g.full_name,
                    proxyInfoSpec: a.spec,
                    proxyType: "aps",
                    proxyApsCode: g.full_code,
                    proxyDelay: g.delay,
                    proxyApsHost: g.host,
                    proxyApsPort: g.port,
                    proxyDelayLevel: getDelayLevel$$module$popup_original(g.delay)
                })
            }
            ;
            m.push(n);
            for (let[g,f] of Object.entries(k)) {
                k = nodeTemplateApsProvince$$module$popup_original.cloneNode(!0);
                n = k.getElementsByTagName("ul")[0];
                if (!Object.isEmpty(f))
                    for (let[e,p] of Object.entries(f)) {
                        const q = nodeTemplateApsCity$$module$popup_original.cloneNode(!0);
                        q.getElementsByClassName("aps-city-name")[0].innerText = p.full_name;
                        if (e === cache$$module$popup_original.proxyApsCode) {
                            var h = q.getElementsByClassName("current")[0];
                            h.innerText = _$$module$popup_original("tipProxyCurrentUse");
                            h.style.display = "inline-block"
                        }
                        q.getElementsByClassName("icon-favor")[0].classList.add(p.favor ? "favor" : "not-favor");
                        q.getElementsByClassName("aps-city-name")[0].innerText = p.full_name;
                        h = q.getElementsByClassName("icon-delay")[0];
                        const r = q.getElementsByClassName("aps-city-delay")[0]
                          , t = getDelayLevel$$module$popup_original(p.delay);
                        r.innerText = "0" !== t ? p.delay + "ms" : _$$module$popup_original("tipOverload");
                        h.dataset.delayLevel = t;
                        q.dataset.show = p.full_name;
                        q.dataset.spec = a.spec;
                        q.dataset.favor = p.favor ? "1" : "0";
                        q.dataset.delay = p.delay;
                        q.dataset.apsHost = p.host;
                        q.dataset.apsPort = p.port;
                        q.dataset.apsCode = p.full_code;
                        q.dataset.delayLevel = t;
                        n.append(q)
                    }
                n.onclick = async function(e) {
                    e.stopPropagation();
                    e = e.target.closest("li").dataset;
                    await setCurrentProxy$$module$popup_original({
                        switchType: "switch-app",
                        proxyInfoShow: e.show,
                        proxyInfoSpec: e.spec,
                        proxyType: "aps",
                        proxyDelay: e.delay,
                        proxyApsCode: e.apsCode,
                        proxyApsHost: e.apsHost,
                        proxyApsPort: e.apsPort,
                        proxyDelayLevel: e.delayLevel
                    })
                }
                ;
                k.getElementsByClassName("aps-province-name")[0].innerText = g;
                k.onclick = function() {
                    if (this.classList.contains("active"))
                        this.classList.remove("active");
                    else {
                        const e = document.getElementsByClassName("aps-province");
                        for (let p of e)
                            p.classList.remove("active");
                        this.classList.add("active")
                    }
                }
                ;
                m.push(k)
            }
        } else
            k.forEach(g => {
                const f = nodeTemplateApsCity$$module$popup_original.cloneNode(!0)
                  , e = l?.[g];
                if (e) {
                    if (g === cache$$module$popup_original.proxyApsCode) {
                        var p = f.getElementsByClassName("current")[0];
                        p.innerText = _$$module$popup_original("tipProxyCurrentUse");
                        p.style.display = "inline-block"
                    }
                    f.getElementsByClassName("icon-favor")[0].classList.add(e.favor ? "favor" : "not-favor");
                    f.getElementsByClassName("aps-city-name")[0].innerText = e.full_name;
                    p = f.getElementsByClassName("icon-delay")[0];
                    var q = f.getElementsByClassName("aps-city-delay")[0]
                      , r = getDelayLevel$$module$popup_original(e.delay);
                    q.innerText = "0" !== r ? e.delay + "ms" : _$$module$popup_original("tipOverload");
                    p.dataset.delayLevel = r;
                    f.dataset.show = e.full_name;
                    f.dataset.spec = a.spec;
                    f.dataset.favor = e.favor ? "1" : "0";
                    f.dataset.delay = e.delay;
                    f.dataset.apsHost = e.host;
                    f.dataset.apsPort = e.port;
                    f.dataset.apsCode = g;
                    f.dataset.delayLevel = r;
                    m.push(f)
                }
            }
            );
        "latest" === d && (nodeApsLatestWrap$$module$popup_original.append(...m),
        m.length && (nodeApsLatestOuterWrap$$module$popup_original.style.display = "block"));
        "favor" === d && (nodeApsFavorWrap$$module$popup_original.append(...m),
        m.length && (nodeApsLatestOuterWrap$$module$popup_original.style.display = "block"));
        "all" === d && (nodeApsAllWrap$$module$popup_original.append(...m),
        m.length && (nodeApsAllOuterWrap$$module$popup_original.style.display = "block"))
    }
    nodeApsLatestOuterWrap$$module$popup_original.style.display = "none";
    nodeApsAllOuterWrap$$module$popup_original.style.display = "none";
    for (nodeAppListNone$$module$popup_original.style.display = "none"; nodeApsLatestWrap$$module$popup_original.firstChild; )
        nodeApsLatestWrap$$module$popup_original.removeChild(nodeApsLatestWrap$$module$popup_original.firstChild);
    for (; nodeApsFavorWrap$$module$popup_original.firstChild; )
        nodeApsFavorWrap$$module$popup_original.removeChild(nodeApsFavorWrap$$module$popup_original.firstChild);
    for (; nodeApsAllWrap$$module$popup_original.firstChild; )
        nodeApsAllWrap$$module$popup_original.removeChild(nodeApsAllWrap$$module$popup_original.firstChild);
    if (Object.isEmpty(a.all))
        nodeAppListNone$$module$popup_original.style.display = "flex",
        clickJump$$module$popup_original(nodePageList$$module$popup_original, "buy-button", backendWebUrl$$module$popup_original.BuyAps, !0);
    else {
        var c = {};
        for (let d of Object.values(a.all))
            for (let[k,l] of Object.entries(d))
                c[k] = l,
                a.favor.includes(k) && (l.favor = !0);
        a.favor?.length && b("favor", a.favor, c);
        a.latest?.length && b("latest", a.latest, c);
        Object.isEmpty(a.all) || b("all", a.all, c);
        nodeApsFavorWrap$$module$popup_original.classList.remove("active");
        nodeApsLatestWrap$$module$popup_original.classList.remove("active");
        nodeApsTitleFavor$$module$popup_original.classList.remove("active");
        nodeApsTitleLatest$$module$popup_original.classList.remove("active");
        a.latest?.length ? (nodeApsLatestWrap$$module$popup_original.classList.add("active"),
        nodeApsTitleLatest$$module$popup_original.classList.add("active")) : a.favor?.length && (nodeApsFavorWrap$$module$popup_original.classList.add("active"),
        nodeApsTitleFavor$$module$popup_original.classList.add("active"));
        nodeApsTitleWrap$$module$popup_original.onclick = async d => {
            d.stopPropagation();
            if (-1 !== d.target.className.indexOf("title-aps-") && !d.target.classList.contains("active")) {
                if (d.target.classList.contains("title-aps-favor") && (nodeApsTitleLatest$$module$popup_original.classList.remove("active"),
                nodeApsLatestWrap$$module$popup_original.classList.remove("active"),
                nodeApsFavorWrap$$module$popup_original.classList.add("active"),
                nodeApsTitleFavor$$module$popup_original.classList.add("active"),
                a.favor.length)) {
                    const k = await getApsFavorList$$module$popup_original();
                    for (; nodeApsFavorWrap$$module$popup_original.firstChild; )
                        nodeApsFavorWrap$$module$popup_original.removeChild(nodeApsFavorWrap$$module$popup_original.firstChild);
                    b("favor", k, c)
                }
                if (d.target.classList.contains("title-aps-latest") && (nodeApsTitleFavor$$module$popup_original.classList.remove("active"),
                nodeApsFavorWrap$$module$popup_original.classList.remove("active"),
                nodeApsTitleLatest$$module$popup_original.classList.add("active"),
                nodeApsLatestWrap$$module$popup_original.classList.add("active"),
                d = await browser$$module$popup_original.getStorageItem("latestApsCode", "[]"),
                d = JSON.parse(d).slice(0, 4),
                d.length)) {
                    for (; nodeApsLatestWrap$$module$popup_original.firstChild; )
                        nodeApsLatestWrap$$module$popup_original.removeChild(nodeApsLatestWrap$$module$popup_original.firstChild);
                    b("latest", d, c)
                }
                addFavorListener$$module$popup_original(!0)
            }
        }
        ;
        nodeApsLatestOuterWrap$$module$popup_original.onclick = async d => {
            d = d.target.closest("li").dataset;
            await setCurrentProxy$$module$popup_original({
                switchType: "switch-app",
                proxyInfoShow: d.show,
                proxyInfoSpec: d.spec,
                proxyType: "aps",
                proxyApsHost: d.apsHost,
                proxyApsPort: d.apsPort,
                proxyApsCode: d.apsCode,
                proxyDelay: d.delay,
                proxyDelayLevel: d.delayLevel
            })
        }
        ;
        addFavorListener$$module$popup_original(!0)
    }
}
async function initExtensionInfo$$module$popup_original() {
    const a = nodeExtensionInfo$$module$popup_original.getElementsByTagName("span")
      , b = cache$$module$popup_original.proxyInfoShow || _$$module$popup_original("tipBugSubmitOrderNotSelected");
    let c = await getTargetDomain$$module$popup_original();
    a[0].innerText = "v" + extensionVersion$$module$popup_original;
    a[1].innerText = await getPlatformInfo$$module$popup_original();
    a[2].innerText = getBrowserInfo$$module$popup_original();
    a[3].innerText = b;
    a[4].innerText = cache$$module$popup_original.username;
    a[5].innerText = c;
    nodeContactMobile$$module$popup_original.value = cache$$module$popup_original.lastContactMobileValue;
    nodeContactQuestion$$module$popup_original.value = cache$$module$popup_original.lastContactQuestionValue;
    nodeContactMobile$$module$popup_original.onblur = () => checkPass$$module$popup_original(nodeContactMobile$$module$popup_original, [checkMobile$$module$popup_original, checkEmail$$module$popup_original], !0);
    nodeContactMobile$$module$popup_original.oninput = () => browser$$module$popup_original.setStorageItem("lastContactMobileValue", nodeContactMobile$$module$popup_original.value.trim(), cache$$module$popup_original);
    nodeContactQuestion$$module$popup_original.oninput = () => browser$$module$popup_original.setStorageItem("lastContactQuestionValue", nodeContactQuestion$$module$popup_original.value.trim(), cache$$module$popup_original);
    let d = !1;
    nodeSubmitBugButton$$module$popup_original.onclick = async () => {
        if (checkPass$$module$popup_original(nodeContactMobile$$module$popup_original, [checkMobile$$module$popup_original, checkEmail$$module$popup_original], !1) && nodeSubmitBugButton$$module$popup_original.value !== _$$module$popup_original("btnSubmitting") && !d) {
            d = !0;
            setTimeout( () => d = !1, 3E3);
            nodeSubmitBugButton$$module$popup_original.value = _$$module$popup_original("btnSubmitting");
            showMessage$$module$popup_original(_$$module$popup_original("tipBugSubmitting"));
            var k = await background$$module$popup_original({
                back: "getLastRequestDomain"
            });
            if (k) {
                k = k.data;
                k.forEach(m => {
                    let n = "";
                    m.url.split("").forEach(h => n += chaos$$module$popup_original(h));
                    m.url = btoa(encodeURIComponent(n))
                }
                );
                var l = "";
                c.split("").forEach(m => l += chaos$$module$popup_original(m));
                await fetchPostWithToken$$module$popup_original(backendExtUrl$$module$popup_original.BugReport, {
                    mobile: nodeContactMobile$$module$popup_original.value.trim(),
                    question: nodeContactQuestion$$module$popup_original.value.trim(),
                    version: a[0].innerText,
                    platform: a[1].innerText,
                    browser: a[2].innerText,
                    proxy: a[3].innerText,
                    domain: btoa(encodeURIComponent(l)),
                    order_id: cache$$module$popup_original.proxyOrderId,
                    histories: k
                }).then(m => {
                    if (m) {
                        nodeSubmitBugButton$$module$popup_original.value = _$$module$popup_original("btnSubmit");
                        if (0 !== m.code)
                            return showMessage$$module$popup_original(`${m.msg}<br/>[code: ${m.code}]`);
                        showMessage$$module$popup_original(_$$module$popup_original("tipBugSubmitSuccess"))
                    }
                }
                )
            }
        }
    }
}
async function initPage$$module$popup_original(a, b) {
    "page-order" === a && (a = "page-list");
    switch (a) {
    case "page-login":
        initLoginMethod$$module$popup_original();
        cache$$module$popup_original.lastMobileValue && (nodeInputMobile$$module$popup_original.value = cache$$module$popup_original.lastMobileValue);
        ~~cache$$module$popup_original.otherLoginMethodClicked || detectAutoLogin$$module$popup_original();
        addLoginListener$$module$popup_original();
        clickJump$$module$popup_original(nodePopupLogin$$module$popup_original, "register", backendWebUrl$$module$popup_original.Register);
        clickJump$$module$popup_original(nodePopupLogin$$module$popup_original, "contract-site", backendWebUrl$$module$popup_original.ContractSite);
        clickJump$$module$popup_original(nodePopupLogin$$module$popup_original, "contract-privacy", backendWebUrl$$module$popup_original.ContractPrivacy);
        break;
    case "page-auto-login":
        setTimeout( () => {
            clearInterval(confirmWxLoginTimer$$module$popup_original);
            clearTimeout(closeWxLoginTimer$$module$popup_original)
        }
        , 2E3);
        addAutoLoginListener$$module$popup_original();
        break;
    case "page-connect":
        initConnectButton$$module$popup_original(b?.reConnect || !1);
        initCurrentProxyPanel$$module$popup_original();
        "switch-order" === cache$$module$popup_original.switchType && (nodeAppInfoPanel$$module$popup_original.style.display = "none",
        nodeIpInfoPanel$$module$popup_original.style.display = "flex",
        initIpInfoPanel$$module$popup_original());
        "switch-app" === cache$$module$popup_original.switchType && (nodeIpInfoPanel$$module$popup_original.style.display = "none",
        nodeAppInfoPanel$$module$popup_original.style.display = "flex",
        initAppInfoPanel$$module$popup_original());
        break;
    case "page-list":
        initPageList$$module$popup_original();
        break;
    case "page-option":
        nodeOptionClearCookie$$module$popup_original.onclick = () => showMessage$$module$popup_original({
            type: "hard",
            status: _$$module$popup_original("tipClearCookieInfo"),
            callback: c => {
                clearCookies$$module$popup_original();
                c.closeSelf()
            }
        });
        nodeOptionBugReport$$module$popup_original.onclick = () => showPage$$module$popup_original("page-bug-report");
        nodeLogoutButton$$module$popup_original.onclick = () => logout$$module$popup_original();
        clickJump$$module$popup_original(nodePageOption$$module$popup_original, "option-buy", backendWebUrl$$module$popup_original.Buy, !0);
        clickJump$$module$popup_original(nodePageOption$$module$popup_original, "option-promoter", backendWebUrl$$module$popup_original.Promoter);
        nodeOptionWebControl$$module$popup_original.onclick = () => {
            let c = {};
            "switch-app" === cache$$module$popup_original.switchType && (cache$$module$popup_original.proxyType = "aps");
            "switch-order" === cache$$module$popup_original.switchType && cache$$module$popup_original.proxyOrderId && (c.orderid = cache$$module$popup_original.proxyOrderId);
            openUrl$$module$popup_original(`${backendWebUrl$$module$popup_original.ControlCenter}${cache$$module$popup_original.proxyType}/`, c, !0)
        }
        ;
        break;
    case "page-bug-report":
        initExtensionInfo$$module$popup_original()
    }
    allPages$$module$popup_original.forEach(c => c.style.display = "none");
    pageFromId$$module$popup_original[a].style.display = "flex";
    initHead$$module$popup_original(a);
    initHeadPic$$module$popup_original(a);
    ["page-login", "page-auto-login"].includes(a) ? (nodePopupLogin$$module$popup_original.style.display = "block",
    clickJump$$module$popup_original([nodePopupLogin$$module$popup_original, nodePopupMain$$module$popup_original], "logo", backendWebUrl$$module$popup_original.Home)) : (nodePopupMain$$module$popup_original.style.display = "block",
    clickJump$$module$popup_original(nodePopupMain$$module$popup_original, "icon-buy", backendWebUrl$$module$popup_original.Buy, !0),
    clickJump$$module$popup_original([nodePopupLogin$$module$popup_original, nodePopupMain$$module$popup_original], "logo", backendWebUrl$$module$popup_original.Home, !0))
}
async function showPage$$module$popup_original(a, b) {
    await browser$$module$popup_original.setStorageItem("currentPageId", a, cache$$module$popup_original);
    await initPage$$module$popup_original(a, b)
}
async function logout$$module$popup_original(a, b) {
    nodeLogoutButton$$module$popup_original.firstElementChild.innerText = _$$module$popup_original("btnLogouting");
    ~~cache$$module$popup_original.connectStatus && await background$$module$popup_original({
        back: "closeConnect"
    });
    clearInterval(timerWaveStar$$module$popup_original);
    clearInterval(timerGetUsedTimer$$module$popup_original);
    clearInterval(sendVcodeTimer$$module$popup_original);
    b || await fetchPostWithToken$$module$popup_original(backendExtUrl$$module$popup_original.Logout);
    await browser$$module$popup_original.clearStorageItem();
    Object.assign(cache$$module$popup_original, defaultCache$$module$popup_original, cacheOverwrite$$module$popup_original);
    await browser$$module$popup_original.setStorageItem("loginStatus", "0", cache$$module$popup_original);
    await showPage$$module$popup_original("page-login");
    nodeLogoutButton$$module$popup_original.firstElementChild.innerText = _$$module$popup_original("btnLogout");
    401 === a && showMessage$$module$popup_original(_$$module$popup_original("tipFetch401"));
    403 === a && showMessage$$module$popup_original(_$$module$popup_original("tipFetch403"));
    404 === a && showMessage$$module$popup_original(_$$module$popup_original("tipFetch404"))
}
function addKeyListener$$module$popup_original() {
    document.body.onkeyup = a => {
        if ("Enter" === a.key) {
            if ("page-login" === cache$$module$popup_original.currentPageId && cache$$module$popup_original.loginMethod === loginMethodMobileId$$module$popup_original)
                return nodeLoginButton$$module$popup_original.click();
            if ("page-auto-login" === cache$$module$popup_original.currentPageId)
                return nodeAutoLoginButton$$module$popup_original.click();
            if ("page-bug-report" === cache$$module$popup_original.currentPageId)
                return nodeSubmitBugButton$$module$popup_original.click()
        }
    }
}
function checkUpdate$$module$popup_original() {
    ("0" === cache$$module$popup_original.lastCheckUpdateTime || 1728E5 <= +new Date - cache$$module$popup_original.lastCheckUpdateTime) && fetchGet$$module$popup_original(backendExtUrl$$module$popup_original.CheckUpdate, {
        version: extensionVersion$$module$popup_original
    }).then(async a => {
        await browser$$module$popup_original.setStorageItem("lastCheckUpdateTime", +new Date, cache$$module$popup_original);
        if (a) {
            if (0 !== a.code)
                return -3 === a.code ? void 0 : showMessage$$module$popup_original(`${a.msg}<br/>[code: ${a.code}]`);
            showMessage$$module$popup_original({
                type: "hard",
                status: _$$module$popup_original("tipUpdateVersion") + `<br/>version:${a.data.version} ${a.data.update_date}`,
                callback: b => {
                    openUrl$$module$popup_original(backendExtUrl$$module$popup_original.Update);
                    b.closeSelf()
                }
            })
        }
    }
    )
}
function checkOffline$$module$popup_original() {
    navigator.onLine || showMessage$$module$popup_original(_$$module$popup_original("errOffline"));
    window.onoffline = () => showMessage$$module$popup_original(_$$module$popup_original("errOffline"))
}
function checkLongTimeIdle$$module$popup_original() {
    return "0" === cache$$module$popup_original.lastPopupTime || 2592E6 > +new Date - cache$$module$popup_original.lastPopupTime ? !1 : !0
}
const cache$$module$popup_original = {}
  , defaultCache$$module$popup_original = {
    currentPageId: "page-connect",
    loginStatus: "0",
    loginMethod: loginMethodWxQrcodeId$$module$popup_original,
    wxLoginQrcode: "",
    wxLoginSceneId: "",
    wxLoginPeriod: "",
    wx_nickname: "",
    wx_mp_openid: "",
    wx_unionid: "",
    username: "",
    subAccountRole: "0",
    identityVerified: "0",
    lastMobileValue: "",
    lastContactMobileValue: "",
    lastContactQuestionValue: "",
    lastPopupTime: "0",
    lastCheckUpdateTime: "0",
    lastRefreshIpInfoTime: "0",
    switchType: "switch-order",
    listSwitchType: "switch-order",
    proxyType: "tps",
    connectStatus: "0",
    proxyUsedTime: "0",
    localIp: "",
    localProvider: "",
    localLocation: "",
    proxyIp: _$$module$popup_original("actionTitleUnconnected"),
    proxyProvider: "",
    proxyLocation: _$$module$popup_original("actionTitleUnconnected"),
    proxySecretId: "",
    proxyOrderId: "",
    proxyLrpsCode: "",
    proxyKpsCode: "",
    proxySfpsCode: "",
    proxyLrpsIdForUser: "",
    proxyKpsIdForUser: "",
    proxySfpsIdForUser: "",
    proxyInfoShow: "",
    proxyInfoSpec: "",
    proxyExpireStatus: "",
    proxyApsCode: "",
    proxyDelay: "",
    proxyDelayLevel: "",
    cachedApsList: "{}",
    latestApsCode: "[]"
}
  , cacheOverwrite$$module$popup_original = {
    otherLoginMethodClicked: "0"
};
(function() {
    browser$$module$popup_original.getStorageItem(null).then(async a => {
        Object.assign(cache$$module$popup_original, defaultCache$$module$popup_original, a, cacheOverwrite$$module$popup_original);
        ~~cache$$module$popup_original.loginStatus || (cache$$module$popup_original.currentPageId = "page-login");
        checkLongTimeIdle$$module$popup_original() && (showMessage$$module$popup_original(_$$module$popup_original("tipFetch777")),
        cache$$module$popup_original.currentPageId = "page-login",
        await background$$module$popup_original({
            back: "closeConnect"
        }),
        await browser$$module$popup_original.setStorageItem("loginStatus", "0", cache$$module$popup_original));
        await showPage$$module$popup_original(cache$$module$popup_original.currentPageId);
        await updateLastPopupTime$$module$popup_original();
        await updateBrowserInfo$$module$popup_original();
        await updatePlatformInfo$$module$popup_original();
        checkUpdate$$module$popup_original();
        checkOffline$$module$popup_original();
        addKeyListener$$module$popup_original();
        autoRefreshIpInfo$$module$popup_original()
    }
    )
}
)();
function checkPass$$module$popup_original(a, b, c) {
    const d = a.value.trim();
    a.classList.remove(classNameInputInvalid$$module$popup_original);
    if (!c || d) {
        if (d)
            if (Array.isArray(b)) {
                if (b.some(k => k(d)))
                    return !0
            } else if (b(d))
                return !0;
        a.classList.add(classNameInputInvalid$$module$popup_original);
        return !1
    }
}
function checkMobile$$module$popup_original(a) {
    if ("string" == typeof a)
        if ("+" != a[0]) {
            if (/^1(3[4-9]|4[78]|5[012789]|65|7[28]|8[23478]|9[58])\d{8}$/m.test(a) || /^1(3[0-2]|4[56]|5[56]|6[67]|8[56]|4[5]|7[156]|8[56])\d{8}$/m.test(a) || /^1(3[3]|49|53|62|7[347]|8[019]|9[139])\d{8}$/m.test(a) || /^19[0267]\d{8}$/m.test(a) || 0 == a.indexOf("1703") || 0 == a.indexOf("1704") || 0 == a.indexOf("1705") || 0 == a.indexOf("1706") || 0 == a.indexOf("1704") || 0 == a.indexOf("1707") || 0 == a.indexOf("1708") || 0 == a.indexOf("1709") || 0 == a.indexOf("1700") || 0 == a.indexOf("1701") || 0 == a.indexOf("1702") || 0 == a.indexOf("1410"))
                return !0
        } else if (/^\+\d{6,15}$/m.test(a))
            return !0;
    return !1
}
function checkDialcodeMobile$$module$popup_original(a, b) {
    a.classList.remove(classNameInputInvalid$$module$popup_original);
    let c = a.value.trim();
    if (!b || c) {
        if (c && (a = a.parentElement.getElementsByClassName("select-value")[0].innerText.trim(),
        "+86" !== a && (c = a + c),
        checkMobile$$module$popup_original(c)))
            return c;
        nodeInputMobile$$module$popup_original.classList.add(classNameInputInvalid$$module$popup_original);
        return !1
    }
}
function checkVerifyCode$$module$popup_original(a) {
    return /^[1-9]\d{5}$/m.test(a)
}
function checkEmail$$module$popup_original(a) {
    return /^([a-zA-Z0-9_\.\-])+@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(a) ? !(a.endsWith("@mailscode.com") || a.endsWith("@oloveo.uu.me")) : !1
}
function saveLoginConfig$$module$popup_original(a) {
    browser$$module$popup_original.setStorageItem({
        loginStatus: "1",
        loginToken: a.token,
        refreshToken: a.refresh_token,
        username: a.user,
        subAccountRole: a.subaccount_role,
        identityVerified: a.identity_verified,
        localIp: a.local_ip_info.ip,
        localProvider: a.local_ip_info.provider,
        localLocation: a.local_ip_info.location,
        wx_nickname: "",
        wx_mp_openid: "",
        wx_unionid: "",
        wxLoginPeriod: "",
        wxLoginSceneId: "",
        wxLoginQrcode: "",
        app_uid: a.app_uid
    }, null, cache$$module$popup_original).then(async () => {
        await showPage$$module$popup_original("page-connect");
        recoverChanges$$module$popup_original();
        closeSoftMessages$$module$popup_original();
        ~~a.is_just_bindweixin_succ && showMessage$$module$popup_original(_$$module$popup_original("tipWxBindSuccess"))
    }
    )
}
let sendVcodeTimer$$module$popup_original;
async function addLoginListener$$module$popup_original() {
    function a() {
        let c = 60;
        nodeSendVcodeButton$$module$popup_original.style.cursor = "not-allowed";
        sendVcodeTimer$$module$popup_original = setInterval( () => {
            c--;
            nodeSendVcodeButton$$module$popup_original.innerText = c + " " + _$$module$popup_original("btnSendVcodeWaiting");
            1 <= c || (nodeSendVcodeButton$$module$popup_original.innerText = _$$module$popup_original("btnSendVcode"),
            nodeSendVcodeButton$$module$popup_original.style.cursor = "pointer",
            clearInterval(sendVcodeTimer$$module$popup_original))
        }
        , 1E3)
    }
    nodeInputVerifyCode$$module$popup_original.onblur = () => checkPass$$module$popup_original(nodeInputVerifyCode$$module$popup_original, checkVerifyCode$$module$popup_original, !0);
    nodeInputMobile$$module$popup_original.onblur = () => checkDialcodeMobile$$module$popup_original(nodeInputMobile$$module$popup_original, !0);
    nodeInputMobile$$module$popup_original.oninput = () => browser$$module$popup_original.setStorageItem("lastMobileValue", nodeInputMobile$$module$popup_original.value.trim(), cache$$module$popup_original);
    let b = !1;
    nodeSendVcodeButton$$module$popup_original.onclick = () => {
        if (!b && (b = !0,
        setTimeout( () => b = !1, 1E4),
        "not-allowed" !== nodeSendVcodeButton$$module$popup_original.style.cursor)) {
            var c = checkDialcodeMobile$$module$popup_original(nodeInputMobile$$module$popup_original, !1);
            c && fetchPostWWW$$module$popup_original(backendWebUrl$$module$popup_original.Vcode, {
                mobile: encodeURIComponent(c),
                vcode_type: "ext_sms_login",
                verify: "",
                voice: "",
                enable_enc: "",
                ncv: "0"
            }).then(d => {
                if (d) {
                    if (0 === d.code)
                        return a();
                    b = !1;
                    return showMessage$$module$popup_original(`${d.msg}<br/>[code: ${d.code}]`)
                }
            }
            )
        }
    }
    ;
    nodeLoginButton$$module$popup_original.onclick = async () => {
        const c = checkDialcodeMobile$$module$popup_original(nodeInputMobile$$module$popup_original, !1);
        if (c && checkPass$$module$popup_original(nodeInputVerifyCode$$module$popup_original, checkVerifyCode$$module$popup_original, !1)) {
            nodeLoginButton$$module$popup_original.value = _$$module$popup_original("btnLogining");
            var d = nodeInputVerifyCode$$module$popup_original.value.trim();
            fetchPost$$module$popup_original(backendExtUrl$$module$popup_original.Login, {
                login_method: "mobile",
                mobile: c,
                verify_code: d,
                wx_nickname: cache$$module$popup_original.wx_nickname,
                wx_mp_openid: cache$$module$popup_original.wx_mp_openid,
                wx_unionid: cache$$module$popup_original.wx_unionid
            }).then(k => {
                nodeLoginButton$$module$popup_original.value = _$$module$popup_original("btnLogin");
                if (k) {
                    if (0 !== k.code)
                        return showMessage$$module$popup_original(`${k.msg}<br/>[code: ${k.code}]`);
                    saveLoginConfig$$module$popup_original(k.data)
                }
            }
            )
        }
    }
}
async function getProxyList$$module$popup_original() {
    let a = await fetchGetWithToken$$module$popup_original(backendExtUrl$$module$popup_original.ProxyList);
    if (a && 0 === a.code)
        return a.data
}
async function getApsList$$module$popup_original() {
    var a = JSON.parse(cache$$module$popup_original.cachedApsList);
    if (!Object.isEmpty(a) && 6E4 > +new Date - a.refresh_time)
        return a;
    if ((a = await fetchGetWithToken$$module$popup_original(backendAppUrl$$module$popup_original.ApsList)) && (0 === a.code || -1 === a.code)) {
        a = a.data;
        a.refresh_time = +new Date;
        a.all.sort( (b, c) => b.province.localeCompare(c.province, "zh-Hans-CN", {
            sensitivity: "accent"
        }));
        for (let b of a.all) {
            b.list.sort( (c, d) => c.city.localeCompare(d.city, "zh-Hans-CN", {
                sensitivity: "accent"
            }));
            for (let c of b.list)
                c.list.sort( (d, k) => d.carrier_name.localeCompare(k.carrier_name, "zh-Hans-CN", {
                    sensitivity: "accent"
                }))
        }
        a.all = a.all.reduce( (b, c) => {
            b[c.province] = c.list.reduce( (d, k) => {
                for (let l of k.list)
                    l.full_name = k.city + " " + l.carrier_name,
                    l.full_code = String(l.city) + String(l.carrier),
                    d[l.full_code] = l;
                return d
            }
            , {});
            return b
        }
        , {});
        browser$$module$popup_original.setStorageItem("cachedApsList", JSON.stringify(a), cache$$module$popup_original);
        return a
    }
}
async function getApsFavorList$$module$popup_original() {
    let a = await fetchGetWithToken$$module$popup_original(backendAppUrl$$module$popup_original.ApsFavor);
    if (a && 0 === a.code)
        return a.data
}
async function getApsConns$$module$popup_original() {
    let a = await fetchGetWithToken$$module$popup_original(backendAppUrl$$module$popup_original.ApsConns);
    if (a && 0 === a.code)
        return a.data
}
var module$popup_original = {};
